/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.blockselector;

import com.google.common.collect.Sets;
import de.derfrzocker.custom.ore.generator.api.ChunkInfo;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.impl.blockselector.AbstractBlockSelector;
import de.derfrzocker.custom.ore.generator.utils.NumberUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class HighestBlockBlockSelector
extends AbstractBlockSelector {
    private static final OreSetting VEINS_PER_CHUNK = OreSetting.createOreSetting("VEINS_PER_CHUNK");
    private static final Set<OreSetting> NEEDED_ORE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new OreSetting[]{VEINS_PER_CHUNK}));

    public HighestBlockBlockSelector(@NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        super("HIGHEST_BLOCK", NEEDED_ORE_SETTINGS, infoFunction, oreSettingInfo);
    }

    @Override
    @NotNull
    public Set<Location> selectBlocks(@NotNull ChunkInfo chunkInfo, @NotNull OreConfig config, @NotNull Random random) {
        HashSet<Location> locations = new HashSet<Location>();
        int veinsPerChunk = NumberUtil.getInt(config.getBlockSelectorOreSettings().getValue(VEINS_PER_CHUNK).orElse(0.0), random);
        for (int i = 0; i < veinsPerChunk; ++i) {
            int x = random.nextInt(16);
            int z = random.nextInt(16);
            locations.add(new Location(null, (double)x, (double)(chunkInfo.getHighestBlock(x, z) - 1), (double)z));
        }
        return locations;
    }

    @Override
    public boolean isSaveValue(@NotNull OreSetting oreSetting, double value, @NotNull OreConfig oreConfig) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        Validate.notNull((Object)oreConfig, (String)"OreConfig can not be null");
        Validate.isTrue((boolean)this.getNeededOreSettings().contains(oreSetting), (String)("The BlockSelector '" + this.getName() + "' does not need the OreSetting '" + oreSetting.getName() + "'"));
        return value >= 0.0;
    }
}

