/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl.blockselector;

import com.google.common.collect.Sets;
import de.derfrzocker.custom.ore.generator.api.ChunkInfo;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import de.derfrzocker.custom.ore.generator.impl.blockselector.AbstractBlockSelector;
import de.derfrzocker.custom.ore.generator.utils.NumberUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class CountRangeBlockSelector
extends AbstractBlockSelector {
    private static final OreSetting HEIGHT_RANGE = OreSetting.createOreSetting("HEIGHT_RANGE");
    private static final OreSetting MINIMUM_HEIGHT = OreSetting.createOreSetting("MINIMUM_HEIGHT");
    private static final OreSetting VEINS_PER_CHUNK = OreSetting.createOreSetting("VEINS_PER_CHUNK");
    private static final Set<OreSetting> NEEDED_ORE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new OreSetting[]{HEIGHT_RANGE, MINIMUM_HEIGHT, VEINS_PER_CHUNK}));

    public CountRangeBlockSelector(@NotNull Function<String, Info> infoFunction, @NotNull BiFunction<String, OreSetting, Info> oreSettingInfo) {
        super("COUNT_RANGE", NEEDED_ORE_SETTINGS, infoFunction, oreSettingInfo);
    }

    @Override
    @NotNull
    public Set<Location> selectBlocks(@NotNull ChunkInfo chunkInfo, @NotNull OreConfig config, @NotNull Random random) {
        HashSet<Location> locations = new HashSet<Location>();
        OreSettingContainer oreSettingContainer = config.getBlockSelectorOreSettings();
        int heightRange = NumberUtil.getInt(oreSettingContainer.getValue(HEIGHT_RANGE).orElse(0.0), random);
        int minimumHeight = NumberUtil.getInt(oreSettingContainer.getValue(MINIMUM_HEIGHT).orElse(0.0), random);
        int veinsPerChunk = NumberUtil.getInt(oreSettingContainer.getValue(VEINS_PER_CHUNK).orElse(0.0), random);
        if (heightRange == 0) {
            return locations;
        }
        for (int i = 0; i < veinsPerChunk; ++i) {
            int x = random.nextInt(16);
            int y = random.nextInt(heightRange) + minimumHeight;
            int z = random.nextInt(16);
            locations.add(new Location(null, (double)x, (double)y, (double)z));
        }
        return locations;
    }

    @Override
    public boolean isSaveValue(@NotNull OreSetting oreSetting, double value, @NotNull OreConfig oreConfig) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        Validate.notNull((Object)oreConfig, (String)"OreConfig can not be null");
        Validate.isTrue((boolean)this.getNeededOreSettings().contains(oreSetting), (String)("The BlockSelector '" + this.getName() + "' does not need the OreSetting '" + oreSetting.getName() + "'"));
        if (oreSetting == HEIGHT_RANGE) {
            return value >= 0.0;
        }
        if (oreSetting == MINIMUM_HEIGHT) {
            return value >= 0.0;
        }
        if (oreSetting == VEINS_PER_CHUNK) {
            return value >= 0.0;
        }
        throw new RuntimeException("Wtf?");
    }
}

