/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl;

import de.derfrzocker.custom.ore.generator.api.BiomeConfig;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.impl.DummyOreConfig;
import de.derfrzocker.custom.ore.generator.impl.OreConfigYamlImpl;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="CustomOreGenerator#WorldConfig")
public class WorldConfigYamlImpl
implements WorldConfig,
ConfigurationSerializable,
ReloadAble {
    private static final Pattern ORE_CONFIG_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]*$");
    @Deprecated
    private static final String WORLD_KEY = "world";
    private static final String NAME_KEY = "name";
    private static final String ORE_CONFIG_KEY = "ore-config";
    @NotNull
    private final String name;
    private final Set<String> allOreConfigs = new LinkedHashSet<String>();
    private final Map<String, OreConfig> oreConfigs = new LinkedHashMap<String, OreConfig>();

    public WorldConfigYamlImpl(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        this.name = name;
    }

    public static WorldConfigYamlImpl deserialize(@NotNull Map<String, Object> map) {
        if (map.containsKey(NAME_KEY)) {
            WorldConfigYamlImpl worldConfig = new WorldConfigYamlImpl((String)map.get(NAME_KEY));
            Object oreConfigs = map.get(ORE_CONFIG_KEY);
            if (oreConfigs != null) {
                ((List)oreConfigs).forEach(oreConfig -> worldConfig.allOreConfigs.add((String)oreConfig));
            }
            return worldConfig;
        }
        WorldConfigYamlImpl worldConfig = new WorldConfigYamlImpl((String)map.get(WORLD_KEY));
        CustomOreGeneratorService service = (CustomOreGeneratorService)Bukkit.getServicesManager().load(CustomOreGeneratorService.class);
        Validate.notNull((Object)service, (String)"CustomOreGeneratorService can not be null");
        if (!map.containsKey(ORE_CONFIG_KEY)) {
            service.getLogger().info("Found very old WorldConfig format, replacing it with new one");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                OreConfigYamlImpl source;
                int index;
                Object value = entry.getValue();
                if (!(value instanceof OreConfigYamlImpl)) continue;
                if (value instanceof DummyOreConfig) {
                    index = 0;
                    while (worldConfig.oreConfigs.containsKey("ore-config_" + index)) {
                        ++index;
                    }
                    source = (DummyOreConfig)value;
                    OreConfigYamlImpl oreConfig2 = new OreConfigYamlImpl("ore-config_" + index, source.getMaterial(), source.getOreGenerator(), source.getBlockSelector());
                    OreConfigYamlImpl.copyData(source, oreConfig2);
                    worldConfig.addOreConfig(oreConfig2);
                    continue;
                }
                if (ORE_CONFIG_NAME_PATTERN.matcher(worldConfig.getName()).matches()) {
                    worldConfig.addOreConfig((OreConfig)value);
                    continue;
                }
                index = 0;
                while (worldConfig.oreConfigs.containsKey("ore-config_" + index)) {
                    ++index;
                }
                source = (OreConfigYamlImpl)value;
                OreConfigYamlImpl oreConfig2 = new OreConfigYamlImpl("ore-config_" + index, source.getMaterial(), source.getOreGenerator(), source.getBlockSelector());
                OreConfigYamlImpl.copyData(source, oreConfig2);
                worldConfig.addOreConfig(oreConfig2);
            }
            for (Map.Entry entry : map.entrySet()) {
                if (!WorldConfigYamlImpl.isBiomeConfig(entry)) continue;
                Set<OreConfig> oreConfigs = worldConfig.convertBiomeConfig((BiomeConfig)entry.getValue());
                oreConfigs.forEach(worldConfig::addOreConfig);
            }
        } else {
            service.getLogger().info("Found old WorldConfig format, replacing it with new one");
            List oreConfigs = (List)map.get(ORE_CONFIG_KEY);
            oreConfigs.forEach(oreConfig -> worldConfig.addOreConfig((OreConfig)oreConfig));
        }
        for (OreConfig oreConfig3 : worldConfig.getOreConfigs()) {
            if (service.getOreConfig(oreConfig3.getName()).isPresent()) {
                int index = 0;
                while (service.getOreConfig(oreConfig3.getName() + "_" + index).isPresent()) {
                    ++index;
                }
                OreConfigYamlImpl newOreConfig = new OreConfigYamlImpl(oreConfig3.getName() + "_" + index, oreConfig3.getMaterial(), oreConfig3.getOreGenerator(), oreConfig3.getBlockSelector());
                OreConfigYamlImpl.copyData(oreConfig3, newOreConfig);
                service.saveOreConfig(newOreConfig);
                continue;
            }
            service.saveOreConfig(oreConfig3);
        }
        service.saveWorldConfig(worldConfig);
        return worldConfig;
    }

    public static void copyData(@NotNull WorldConfig toCopy, @NotNull WorldConfigYamlImpl target) {
        Validate.notNull((Object)toCopy, (String)"ToCopy WorldConfig can not be null");
        Validate.notNull((Object)target, (String)"Target WorldConfig can not be null");
        target.allOreConfigs.clear();
        target.oreConfigs.clear();
        target.allOreConfigs.addAll(toCopy.getAllOreConfigs());
    }

    @Deprecated
    private static boolean isBiomeConfig(@NotNull Map.Entry<String, Object> entry) {
        return entry.getValue() instanceof BiomeConfig;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Optional<OreConfig> getOreConfig(@NotNull String name) {
        Validate.notNull((Object)name, (String)"World name can not be null");
        this.checkOreConfigs();
        return Optional.ofNullable(this.oreConfigs.get(name));
    }

    @Override
    @NotNull
    public Set<OreConfig> getOreConfigs() {
        this.checkOreConfigs();
        return new LinkedHashSet<OreConfig>(this.oreConfigs.values());
    }

    @Override
    public void addOreConfig(@NotNull OreConfig oreConfig) {
        Validate.notNull((Object)oreConfig, (String)"OreConfig can not be null");
        Validate.isTrue((!this.allOreConfigs.contains(oreConfig.getName()) ? 1 : 0) != 0, (String)("The OreConfig " + oreConfig.getName() + " is already added to the WorldConfig " + this.getName()));
        this.oreConfigs.put(oreConfig.getName(), oreConfig);
        this.allOreConfigs.add(oreConfig.getName());
    }

    @Override
    public void addOreConfig(@NotNull OreConfig oreConfig, int position) {
        Set<String> allOreConfigs = this.getAllOreConfigs();
        this.allOreConfigs.clear();
        this.oreConfigs.clear();
        if (position < 0) {
            position = 0;
        }
        int current = 0;
        String storage = oreConfig.getName();
        allOreConfigs.remove(storage);
        for (String oreConfigName : allOreConfigs) {
            if (current >= position) {
                this.allOreConfigs.add(storage);
                storage = oreConfigName;
            } else {
                this.allOreConfigs.add(oreConfigName);
            }
            ++current;
        }
        this.allOreConfigs.add(storage);
    }

    @Override
    public Set<String> getAllOreConfigs() {
        return new LinkedHashSet<String>(this.allOreConfigs);
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> serialize = new LinkedHashMap<String, Object>();
        serialize.put(NAME_KEY, this.getName());
        if (!this.getAllOreConfigs().isEmpty()) {
            serialize.put(ORE_CONFIG_KEY, new LinkedList<String>(this.getAllOreConfigs()));
        }
        return serialize;
    }

    @Override
    public void reload() {
        this.oreConfigs.clear();
    }

    @Deprecated
    private Set<OreConfig> convertBiomeConfig(@NotNull BiomeConfig biomeConfig) {
        HashSet<OreConfig> oreConfigs = new HashSet<OreConfig>();
        int index = 0;
        while (this.oreConfigs.containsKey("biome-config_" + index)) {
            ++index;
        }
        for (OreConfig source : biomeConfig.getOreConfigs()) {
            OreConfigYamlImpl oreConfig = new OreConfigYamlImpl("biome-config_" + index, source.getMaterial(), source.getOreGenerator(), source.getBlockSelector());
            OreConfigYamlImpl.copyData(source, oreConfig);
            oreConfig.setGeneratedAll(false);
            oreConfig.addBiome(biomeConfig.getBiome());
            oreConfigs.add(oreConfig);
            ++index;
        }
        return oreConfigs;
    }

    private void checkOreConfigs() {
        if (this.allOreConfigs.size() == this.oreConfigs.size()) {
            return;
        }
        CustomOreGeneratorService service = (CustomOreGeneratorService)Bukkit.getServicesManager().load(CustomOreGeneratorService.class);
        LinkedHashMap map = new LinkedHashMap();
        if (service == null) {
            return;
        }
        this.allOreConfigs.forEach(name -> {
            OreConfig oreConfig = this.oreConfigs.get(name);
            if (oreConfig != null) {
                map.put(name, oreConfig);
            }
            Optional<OreConfig> optionalOreConfig = service.getOreConfig((String)name);
            optionalOreConfig.ifPresent(config -> map.put(name, config));
        });
        this.oreConfigs.clear();
        this.oreConfigs.putAll(map);
    }
}

