/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl;

import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="CustomOreGenerator#OreSettingsContainer")
public class OreSettingsContainerYamlImpl
implements OreSettingContainer,
ConfigurationSerializable {
    private static final String ORE_SETTINGS_KEY = "ore-settings";
    @NotNull
    private final Map<OreSetting, Double> oreSettings = new LinkedHashMap<OreSetting, Double>();

    public static OreSettingsContainerYamlImpl deserialize(@NotNull Map<String, Object> map) {
        Validate.notNull(map, (String)"Map can not be null");
        OreSettingsContainerYamlImpl oreSettingContainer = new OreSettingsContainerYamlImpl();
        if (map.containsKey(ORE_SETTINGS_KEY)) {
            ((Map)map.get(ORE_SETTINGS_KEY)).forEach((setting, value) -> oreSettingContainer.setValue(OreSetting.createOreSetting(setting), NumberConversions.toDouble((Object)value)));
        }
        return oreSettingContainer;
    }

    @Override
    public void setValue(@NotNull OreSetting oreSetting, double value) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        this.oreSettings.put(oreSetting, value);
    }

    @Override
    @NotNull
    public Optional<Double> getValue(@NotNull OreSetting oreSetting) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        return Optional.ofNullable(this.oreSettings.get(oreSetting));
    }

    @Override
    public boolean removeValue(@NotNull OreSetting oreSetting) {
        Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
        return this.oreSettings.remove(oreSetting) != null;
    }

    @Override
    @NotNull
    public Map<OreSetting, Double> getValues() {
        return new LinkedHashMap<OreSetting, Double>(this.oreSettings);
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> serialize = new LinkedHashMap<String, Object>();
        Map<OreSetting, Double> oreSettings = this.getValues();
        if (!oreSettings.isEmpty()) {
            LinkedHashMap data = new LinkedHashMap();
            oreSettings.forEach((oreSetting, aDouble) -> data.put(oreSetting.getName(), aDouble));
            serialize.put(ORE_SETTINGS_KEY, data);
        }
        return serialize;
    }
}

