/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.impl.DummyOreConfig;
import de.derfrzocker.custom.ore.generator.impl.OreSettingsContainerYamlImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializableAs(value="CustomOreGenerator#OreConfig")
public class OreConfigYamlImpl
implements OreConfig,
ConfigurationSerializable {
    private static final String NAME_KEY = "name";
    private static final String MATERIAL_KEY = "material";
    @Deprecated
    private static final String ORE_GENERATOR_KEY_OLD = "ore_generator";
    private static final String ORE_GENERATOR_KEY = "ore-generator";
    private static final String BLOCK_SELECTOR_KEY = "block-selector";
    private static final String ACTIVATED_KEY = "activated";
    private static final String GENERATED_ALL_KEY = "generated-all";
    private static final String BIOMES_KEY = "biomes";
    private static final String REPLACE_MATERIALS_KEY = "replace-materials";
    private static final String SELECT_MATERIALS_KEY = "select-materials";
    private static final String CUSTOM_DATA_KEY = "custom-data";
    @Deprecated
    private static final String ORE_SETTINGS_KEY = "ore-settings";
    private static final String ORE_GENERATOR_SETTINGS_KEY = "ore-generator-settings";
    private static final String BLOCK_SELECTOR_SETTINGS_KEY = "block-selector-settings";
    @NotNull
    private final String name;
    @NotNull
    private final Material material;
    private final Set<String> invalidBiome = new HashSet<String>();
    private final Set<Biome> biomes = new HashSet<Biome>();
    private final Set<Material> replaceMaterials = new HashSet<Material>();
    private final Set<Material> selectMaterials = new HashSet<Material>();
    private final OreSettingContainer oreGeneratorOreSettings = new OreSettingsContainerYamlImpl();
    private final OreSettingContainer blockSelectorOreSettings = new OreSettingsContainerYamlImpl();
    private final Map<String, Object> lazyCustomData = new HashMap<String, Object>();
    private final Map<CustomData, Object> customData = new HashMap<CustomData, Object>();
    @Deprecated
    private final Map<OreSetting, Double> unsortedOreSettings = new HashMap<OreSetting, Double>();
    @NotNull
    private String oreGenerator;
    @NotNull
    private String blockSelector;
    private boolean activated = true;
    private boolean generatedAll = true;
    private static final Map<String, String> REPLACMENTS = new HashMap<String, String>();

    public OreConfigYamlImpl(@NotNull String name, @NotNull Material material, @NotNull String oreGenerator, @NotNull String blockSelector) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        Validate.notEmpty((String)name, (String)"Name can not be empty");
        Validate.notNull((Object)material, (String)"Material can not be empty");
        Validate.notNull((Object)oreGenerator, (String)"OreGenerator can not be null");
        Validate.notEmpty((String)oreGenerator, (String)"OreGenerator can not be empty");
        Validate.notNull((Object)blockSelector, (String)"BlockSelector can not be null");
        Validate.notEmpty((String)blockSelector, (String)"BlockSelector can not be empty");
        this.name = name;
        this.material = material;
        this.oreGenerator = oreGenerator;
        this.blockSelector = blockSelector;
    }

    public static OreConfigYamlImpl deserialize(@NotNull Map<String, Object> map) {
        OreConfigYamlImpl oreConfig;
        Validate.notNull(map, (String)"Map can not be null");
        CustomOreGeneratorService service = (CustomOreGeneratorService)Bukkit.getServicesManager().load(CustomOreGeneratorService.class);
        Validate.notNull((Object)service, (String)"CustomOreGeneratorService can not be null");
        if (!map.containsKey(NAME_KEY)) {
            service.getLogger().info("Found old OreConfig format, replacing it with new one");
            BlockSelector blockSelector = service.getDefaultBlockSelector();
            Validate.notNull((Object)blockSelector, (String)"Default BlockSelector is null");
            oreConfig = new DummyOreConfig(Material.valueOf((String)((String)map.get(MATERIAL_KEY))), ((String)map.get(ORE_GENERATOR_KEY_OLD)).toUpperCase(), blockSelector.getName());
            map.entrySet().stream().filter(entry -> OreSetting.getOreSetting((String)entry.getKey()) != null).forEach(entry -> oreConfig.unsortedOreSettings.put(OreSetting.createOreSetting((String)entry.getKey()), NumberConversions.toDouble(entry.getValue())));
            oreConfig.addReplaceMaterial(Material.STONE);
        } else {
            String blockSelectorName;
            if (!map.containsKey(BLOCK_SELECTOR_KEY)) {
                service.getLogger().warning("BlockSelector not found try to use default one");
                BlockSelector blockSelector = service.getDefaultBlockSelector();
                Validate.notNull((Object)blockSelector, (String)"Default BlockSelector is null");
                blockSelectorName = blockSelector.getName();
            } else {
                blockSelectorName = (String)map.get(BLOCK_SELECTOR_KEY);
            }
            oreConfig = new OreConfigYamlImpl((String)map.get(NAME_KEY), Material.valueOf((String)((String)map.get(MATERIAL_KEY))), ((String)map.get(ORE_GENERATOR_KEY)).toUpperCase(), blockSelectorName);
            oreConfig.setActivated((Boolean)map.get(ACTIVATED_KEY));
            oreConfig.setGeneratedAll((Boolean)map.get(GENERATED_ALL_KEY));
            if (map.containsKey(BIOMES_KEY)) {
                for (String biomeString : (List)map.get(BIOMES_KEY)) {
                    try {
                        oreConfig.addBiome(Biome.valueOf((String)biomeString));
                    }
                    catch (IllegalArgumentException e) {
                        oreConfig.invalidBiome.add(biomeString);
                        service.getLogger().warning("OreConfig: " + oreConfig.getName() + " >> The biome " + biomeString + " is not present in this server version ignoring it!");
                    }
                }
            }
            if (map.containsKey(REPLACE_MATERIALS_KEY)) {
                ((List)map.get(REPLACE_MATERIALS_KEY)).forEach(material -> oreConfig.addReplaceMaterial(Material.valueOf((String)material)));
            }
            if (map.containsKey(SELECT_MATERIALS_KEY)) {
                ((List)map.get(SELECT_MATERIALS_KEY)).forEach(material -> oreConfig.addSelectMaterial(Material.valueOf((String)material)));
            }
            if (map.containsKey(CUSTOM_DATA_KEY)) {
                oreConfig.lazyCustomData.putAll((Map)map.get(CUSTOM_DATA_KEY));
            }
            if (map.containsKey(ORE_SETTINGS_KEY)) {
                ((Map)map.get(ORE_SETTINGS_KEY)).forEach((setting, value) -> oreConfig.unsortedOreSettings.put(OreSetting.createOreSetting(OreConfigYamlImpl.replace(setting)), NumberConversions.toDouble((Object)value)));
            }
            if (map.containsKey(ORE_GENERATOR_SETTINGS_KEY)) {
                ((OreSettingContainer)map.get(ORE_GENERATOR_SETTINGS_KEY)).getValues().forEach((oreSetting, aDouble) -> oreConfig.oreGeneratorOreSettings.setValue(OreSetting.createOreSetting(OreConfigYamlImpl.replace(oreSetting.getName())), (double)aDouble));
            }
            if (map.containsKey(BLOCK_SELECTOR_SETTINGS_KEY)) {
                ((OreSettingContainer)map.get(BLOCK_SELECTOR_SETTINGS_KEY)).getValues().forEach((oreSetting, aDouble) -> oreConfig.blockSelectorOreSettings.setValue(OreSetting.createOreSetting(OreConfigYamlImpl.replace(oreSetting.getName())), (double)aDouble));
            }
        }
        return oreConfig;
    }

    private static String replace(@NotNull String oreSetting) {
        return REPLACMENTS.getOrDefault(oreSetting, oreSetting);
    }

    public static void copyData(@NotNull OreConfig toCopy, @NotNull OreConfigYamlImpl target) {
        Validate.notNull((Object)toCopy, (String)"ToCopy OreConfig can not be null");
        Validate.notNull((Object)target, (String)"Target OreConfig can not be null");
        target.setActivated(toCopy.isActivated());
        target.setGeneratedAll(toCopy.shouldGeneratedAll());
        target.getBiomes().forEach(target::addBiome);
        toCopy.getCustomData().forEach(target::setCustomData);
        toCopy.getOreGeneratorOreSettings().getValues().forEach((oreSetting, aDouble) -> target.getOreGeneratorOreSettings().setValue((OreSetting)oreSetting, (double)aDouble));
        toCopy.getBlockSelectorOreSettings().getValues().forEach((oreSetting, aDouble) -> target.getBlockSelectorOreSettings().setValue((OreSetting)oreSetting, (double)aDouble));
        toCopy.getReplaceMaterials().forEach(target::addReplaceMaterial);
        toCopy.getSelectMaterials().forEach(target::addSelectMaterial);
        target.lazyCustomData.putAll(toCopy.getLazyCustomData());
        if (toCopy instanceof OreConfigYamlImpl) {
            ((OreConfigYamlImpl)toCopy).unsortedOreSettings.forEach((oreSetting, aDouble) -> target.unsortedOreSettings.put((OreSetting)oreSetting, (Double)aDouble));
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    @Override
    public boolean shouldGeneratedAll() {
        return this.generatedAll;
    }

    @Override
    public void setGeneratedAll(boolean generatedAll) {
        this.generatedAll = generatedAll;
    }

    @Override
    @NotNull
    public Set<Biome> getBiomes() {
        return new HashSet<Biome>(this.biomes);
    }

    @Override
    public void addBiome(@NotNull Biome biome) {
        Validate.notNull((Object)biome, (String)"Biome can not be null");
        this.biomes.add(biome);
    }

    @Override
    public void removeBiome(@NotNull Biome biome) {
        Validate.notNull((Object)biome, (String)"Biome can not be null");
        this.biomes.remove(biome);
    }

    @Override
    @NotNull
    public Material getMaterial() {
        return this.material;
    }

    @Override
    @NotNull
    public String getOreGenerator() {
        return this.oreGenerator;
    }

    @Override
    public void setOreGenerator(@NotNull OreGenerator oreGenerator) {
        Validate.notNull((Object)oreGenerator, (String)"OreGenerator can not be null");
        this.oreGenerator = oreGenerator.getName();
    }

    @Override
    @NotNull
    public String getBlockSelector() {
        return this.blockSelector;
    }

    @Override
    public void setBlockSelector(@NotNull BlockSelector blockSelector) {
        Validate.notNull((Object)blockSelector, (String)"BlockSelector can not be null");
        this.blockSelector = blockSelector.getName();
    }

    @Override
    @NotNull
    public OreSettingContainer getOreGeneratorOreSettings() {
        this.checkUnsortedValues();
        return this.oreGeneratorOreSettings;
    }

    @Override
    @NotNull
    public OreSettingContainer getBlockSelectorOreSettings() {
        this.checkUnsortedValues();
        return this.blockSelectorOreSettings;
    }

    @Override
    @NotNull
    public Map<CustomData, Object> getCustomData() {
        this.checkLazyCustomData();
        return new HashMap<CustomData, Object>(this.customData);
    }

    @Override
    @NotNull
    public Map<String, Object> getLazyCustomData() {
        this.checkLazyCustomData();
        return new HashMap<String, Object>(this.lazyCustomData);
    }

    @Override
    @NotNull
    public Optional<Object> getCustomData(@NotNull CustomData customData) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        return Optional.ofNullable(this.getCustomData().get(customData));
    }

    @Override
    public void setCustomData(@NotNull CustomData customData, @Nullable Object data) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        this.checkLazyCustomData();
        if (data == null) {
            this.customData.remove(customData);
        } else {
            this.customData.put(customData, data);
        }
    }

    @Override
    @NotNull
    public Set<Material> getReplaceMaterials() {
        return new HashSet<Material>(this.replaceMaterials);
    }

    @Override
    public void addReplaceMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.replaceMaterials.add(material);
    }

    @Override
    public void removeReplaceMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.replaceMaterials.remove(material);
    }

    @Override
    @NotNull
    public Set<Material> getSelectMaterials() {
        return new HashSet<Material>(this.selectMaterials);
    }

    @Override
    public void addSelectMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.selectMaterials.add(material);
    }

    @Override
    public void removeSelectMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.selectMaterials.remove(material);
    }

    @NotNull
    public Map<String, Object> serialize() {
        OreSettingContainer blockSelectorOreSettings;
        OreSettingContainer oreGeneratorOreSettings;
        LinkedHashMap<String, Object> data;
        Map<CustomData, Object> customDataMap;
        Set<Material> selectMaterialsSet;
        Set<Material> replaceMaterialsSet;
        LinkedHashMap<String, Object> serialize = new LinkedHashMap<String, Object>();
        serialize.put(NAME_KEY, this.getName());
        serialize.put(MATERIAL_KEY, this.getMaterial().toString());
        serialize.put(ORE_GENERATOR_KEY, this.getOreGenerator());
        serialize.put(BLOCK_SELECTOR_KEY, this.getBlockSelector());
        serialize.put(ACTIVATED_KEY, this.isActivated());
        serialize.put(GENERATED_ALL_KEY, this.shouldGeneratedAll());
        Set<Biome> biomesSet = this.getBiomes();
        if (!biomesSet.isEmpty()) {
            ArrayList<String> data2 = new ArrayList<String>();
            biomesSet.forEach(biome -> data2.add(biome.toString()));
            data2.addAll(this.invalidBiome);
            serialize.put(BIOMES_KEY, data2);
        }
        if (!(replaceMaterialsSet = this.getReplaceMaterials()).isEmpty()) {
            ArrayList data3 = new ArrayList();
            replaceMaterialsSet.forEach(material -> data3.add(material.toString()));
            serialize.put(REPLACE_MATERIALS_KEY, data3);
        }
        if (!(selectMaterialsSet = this.getSelectMaterials()).isEmpty()) {
            ArrayList data4 = new ArrayList();
            selectMaterialsSet.forEach(material -> data4.add(material.toString()));
            serialize.put(SELECT_MATERIALS_KEY, data4);
        }
        if (!(customDataMap = this.getCustomData()).isEmpty() || !this.lazyCustomData.isEmpty()) {
            data = new LinkedHashMap<String, Object>(this.lazyCustomData);
            customDataMap.forEach((customData, object) -> data.put(customData.getName(), object));
            serialize.put(CUSTOM_DATA_KEY, data);
        }
        if (!this.unsortedOreSettings.isEmpty()) {
            data = new LinkedHashMap();
            this.unsortedOreSettings.forEach((key, value) -> data.put(key.getName(), value));
            serialize.put(ORE_SETTINGS_KEY, data);
        }
        if (!(oreGeneratorOreSettings = this.getOreGeneratorOreSettings()).getValues().isEmpty()) {
            if (oreGeneratorOreSettings instanceof ConfigurationSerializable) {
                serialize.put(ORE_GENERATOR_SETTINGS_KEY, oreGeneratorOreSettings);
            } else {
                OreSettingsContainerYamlImpl oreSettingContainer = new OreSettingsContainerYamlImpl();
                oreGeneratorOreSettings.getValues().forEach(oreSettingContainer::setValue);
                serialize.put(ORE_GENERATOR_SETTINGS_KEY, oreSettingContainer);
            }
        }
        if (!(blockSelectorOreSettings = this.getBlockSelectorOreSettings()).getValues().isEmpty()) {
            if (blockSelectorOreSettings instanceof ConfigurationSerializable) {
                serialize.put(BLOCK_SELECTOR_SETTINGS_KEY, blockSelectorOreSettings);
            } else {
                OreSettingsContainerYamlImpl oreSettingContainer = new OreSettingsContainerYamlImpl();
                blockSelectorOreSettings.getValues().forEach(oreSettingContainer::setValue);
                serialize.put(BLOCK_SELECTOR_SETTINGS_KEY, oreSettingContainer);
            }
        }
        return serialize;
    }

    @Deprecated
    private void checkUnsortedValues() {
        if (this.unsortedOreSettings.isEmpty()) {
            return;
        }
        HashSet toRemove = new HashSet();
        this.unsortedOreSettings.keySet().stream().filter(oreSetting -> this.oreGeneratorOreSettings.getValue((OreSetting)oreSetting).isPresent() || this.blockSelectorOreSettings.getValue((OreSetting)oreSetting).isPresent()).forEach(toRemove::add);
        CustomOreGeneratorService service = (CustomOreGeneratorService)Bukkit.getServicesManager().load(CustomOreGeneratorService.class);
        if (service != null) {
            Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(this.getOreGenerator());
            optionalOreGenerator.ifPresent(oreGenerator -> this.unsortedOreSettings.entrySet().stream().filter(entry -> oreGenerator.getNeededOreSettings().contains(entry.getKey())).forEach(entry -> {
                toRemove.add((OreSetting)entry.getKey());
                this.oreGeneratorOreSettings.setValue((OreSetting)entry.getKey(), (Double)entry.getValue());
            }));
            Optional<BlockSelector> optionalBlockSelector = service.getBlockSelector(this.getBlockSelector());
            optionalBlockSelector.ifPresent(blockSelector -> this.unsortedOreSettings.entrySet().stream().filter(entry -> blockSelector.getNeededOreSettings().contains(entry.getKey())).forEach(entry -> {
                toRemove.add((OreSetting)entry.getKey());
                this.blockSelectorOreSettings.setValue((OreSetting)entry.getKey(), (Double)entry.getValue());
            }));
        }
        toRemove.forEach(this.unsortedOreSettings::remove);
    }

    private void checkLazyCustomData() {
        if (this.lazyCustomData.isEmpty()) {
            return;
        }
        CustomOreGeneratorService customOreGeneratorService = (CustomOreGeneratorService)Bukkit.getServicesManager().load(CustomOreGeneratorService.class);
        HashSet toRemove = new HashSet();
        if (customOreGeneratorService == null) {
            return;
        }
        this.lazyCustomData.forEach((name, value) -> {
            Optional<CustomData> customDataOptional = customOreGeneratorService.getCustomData((String)name);
            if (!customDataOptional.isPresent()) {
                return;
            }
            toRemove.add(name);
            this.customData.put(customDataOptional.get(), value);
        });
        toRemove.forEach(this.lazyCustomData::remove);
    }

    static {
        REPLACMENTS.put("CONTINUE_CHANGE", "CONTINUE_CHANCE");
        REPLACMENTS.put("MINIMUM_CHANGE_SUBTRACTION", "MINIMUM_CHANCE_SUBTRACTION");
        REPLACMENTS.put("CHANGE_SUBTRACTION_RANGE", "CHANCE_SUBTRACTION_RANGE");
        REPLACMENTS.put("DOWN_CHANGE", "DOWN_CHANCE");
    }
}

