/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl;

import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.utils.Config;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class InfoImpl
implements Info,
ReloadAble {
    @NotNull
    private final Supplier<ConfigurationSection> configurationSectionSupplier;
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private ConfigurationSection section;

    public InfoImpl(@NotNull JavaPlugin plugin, @NotNull String file) {
        this(plugin, file, true);
    }

    public InfoImpl(@NotNull JavaPlugin plugin, @NotNull String file, boolean copy) {
        this(plugin, () -> copy ? Config.getConfig((Plugin)plugin, file) : new Config(plugin.getResource(file)));
    }

    public InfoImpl(@NotNull JavaPlugin plugin, @NotNull Supplier<ConfigurationSection> configurationSectionSupplier) {
        Validate.notNull((Object)plugin, (String)"JavaPlugin can not be null");
        Validate.notNull(configurationSectionSupplier, (String)"Supplier can not be null");
        this.configurationSectionSupplier = configurationSectionSupplier;
        this.plugin = plugin;
        this.section = configurationSectionSupplier.get();
        RELOAD_ABLES.add(this);
        this.reload();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return MessageUtil.replacePlaceHolder((Plugin)this.plugin, this.section.getString("display-name"), new MessageValue[0]);
    }

    @Override
    @NotNull
    public Material getMaterial() {
        return Material.valueOf((String)this.section.getString("material"));
    }

    @Override
    @NotNull
    public String getDescription() {
        return MessageUtil.replacePlaceHolder((Plugin)this.plugin, this.section.getString("description"), new MessageValue[0]);
    }

    @Override
    public void reload() {
        this.section = this.configurationSectionSupplier.get();
    }
}

