/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.impl;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.dao.OreConfigDao;
import de.derfrzocker.custom.ore.generator.api.dao.WorldConfigDao;
import de.derfrzocker.custom.ore.generator.impl.OreConfigYamlImpl;
import de.derfrzocker.custom.ore.generator.impl.WorldConfigYamlImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomOreGeneratorServiceImpl
implements CustomOreGeneratorService {
    private static final Pattern BLOCK_SELECTOR_NAME_PATTERN;
    private static final Pattern ORE_GENERATOR_NAME_PATTERN;
    private static final Pattern CUSTOM_DATA_NAME_PATTERN;
    private static final Pattern ORE_CONFIG_NAME_PATTERN;
    @NotNull
    private final WorldConfigDao worldConfigDao;
    @NotNull
    private final OreConfigDao oreConfigDao;
    @NotNull
    private final Logger logger;
    private final Map<String, BlockSelector> blockSelectors = new HashMap<String, BlockSelector>();
    private final Map<String, OreGenerator> oreGenerators = new HashMap<String, OreGenerator>();
    private final Map<String, CustomData> customDatas = new HashMap<String, CustomData>();
    @Nullable
    private BlockSelector defaultBlockSelector;
    @Nullable
    private OreGenerator defaultOreGenerator;

    public CustomOreGeneratorServiceImpl(@NotNull WorldConfigDao worldConfigDao, @NotNull OreConfigDao oreConfigDao, @NotNull Logger logger) {
        Validate.notNull((Object)worldConfigDao, (String)"WorldConfigDao can not be null");
        Validate.notNull((Object)oreConfigDao, (String)"OreConfigDao can not be null");
        Validate.notNull((Object)logger, (String)"Logger can not be null");
        this.worldConfigDao = worldConfigDao;
        this.oreConfigDao = oreConfigDao;
        this.logger = logger;
    }

    @Override
    @NotNull
    public Optional<BlockSelector> getBlockSelector(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        return Optional.ofNullable(this.blockSelectors.get(name.toUpperCase()));
    }

    @Override
    public void registerBlockSelector(@NotNull BlockSelector blockSelector) {
        Validate.notNull((Object)blockSelector, (String)"BlockSelector can not be null");
        Validate.notEmpty((String)blockSelector.getName(), (String)"BlockSelector name can not be empty");
        Validate.isTrue((!this.getBlockSelector(blockSelector.getName()).isPresent() ? 1 : 0) != 0, (String)("BlockSelector " + blockSelector.getName() + " is already registered"));
        Validate.isTrue((boolean)BLOCK_SELECTOR_NAME_PATTERN.matcher(blockSelector.getName()).matches(), (String)("BlockSelector " + blockSelector.getName() + " does not match the regex: ^[A-Z_]*$"));
        this.blockSelectors.put(blockSelector.getName(), blockSelector);
    }

    @Override
    @NotNull
    public Set<BlockSelector> getBlockSelectors() {
        return new HashSet<BlockSelector>(this.blockSelectors.values());
    }

    @Override
    @Nullable
    public BlockSelector getDefaultBlockSelector() {
        return this.defaultBlockSelector;
    }

    @Override
    public void setDefaultBlockSelector(@Nullable BlockSelector blockSelector) {
        if (blockSelector == null) {
            this.defaultBlockSelector = null;
            return;
        }
        Validate.isTrue((boolean)this.getBlockSelector(blockSelector.getName()).isPresent(), (String)("BlockSelector " + blockSelector.getName() + " is not registered"));
        this.defaultBlockSelector = blockSelector;
    }

    @Override
    @NotNull
    public Optional<OreGenerator> getOreGenerator(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        return Optional.ofNullable(this.oreGenerators.get(name.toUpperCase()));
    }

    @Override
    public void registerOreGenerator(@NotNull OreGenerator oreGenerator) {
        Validate.notNull((Object)oreGenerator, (String)"OreGenerator can not be null");
        Validate.notEmpty((String)oreGenerator.getName(), (String)"OreGenerator name can not be empty");
        Validate.isTrue((!this.getOreGenerator(oreGenerator.getName()).isPresent() ? 1 : 0) != 0, (String)("OreGenerator " + oreGenerator.getName() + " is already registered"));
        Validate.isTrue((boolean)ORE_GENERATOR_NAME_PATTERN.matcher(oreGenerator.getName()).matches(), (String)("OreGenerator " + oreGenerator.getName() + " does not match the regex: ^[A-Z_]*$"));
        this.oreGenerators.put(oreGenerator.getName(), oreGenerator);
    }

    @Override
    @NotNull
    public Set<OreGenerator> getOreGenerators() {
        return new HashSet<OreGenerator>(this.oreGenerators.values());
    }

    @Override
    @Nullable
    public OreGenerator getDefaultOreGenerator() {
        return this.defaultOreGenerator;
    }

    @Override
    public void setDefaultOreGenerator(@Nullable OreGenerator oreGenerator) {
        if (oreGenerator == null) {
            this.defaultOreGenerator = null;
            return;
        }
        Validate.isTrue((boolean)this.getOreGenerator(oreGenerator.getName()).isPresent(), (String)("OreGenerator " + oreGenerator.getName() + " is not registered"));
        this.defaultOreGenerator = oreGenerator;
    }

    @Override
    @NotNull
    public Optional<CustomData> getCustomData(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        return Optional.ofNullable(this.customDatas.get(name.toUpperCase()));
    }

    @Override
    public void registerCustomData(@NotNull CustomData customData) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        Validate.notEmpty((String)customData.getName(), (String)"CustomData name can not be empty");
        Validate.isTrue((!this.getCustomData(customData.getName()).isPresent() ? 1 : 0) != 0, (String)("CustomData " + customData.getName() + " is already registered"));
        Validate.isTrue((boolean)CUSTOM_DATA_NAME_PATTERN.matcher(customData.getName()).matches(), (String)("CustomData " + customData.getName() + " does not match the regex: ^[A-Z_]*$"));
        this.customDatas.put(customData.getName(), customData);
    }

    @Override
    @NotNull
    public Set<CustomData> getCustomData() {
        return new HashSet<CustomData>(this.customDatas.values());
    }

    @Override
    @NotNull
    public Optional<WorldConfig> getWorldConfig(@NotNull String worldName) {
        Validate.notNull((Object)worldName, (String)"World name can not be null");
        return this.worldConfigDao.get(worldName);
    }

    @Override
    @NotNull
    public WorldConfig createWorldConfig(@NotNull World world) {
        Validate.notNull((Object)world, (String)"World can not be null");
        return this.getWorldConfig(world.getName()).orElseGet(() -> new WorldConfigYamlImpl(world.getName()));
    }

    @Override
    @NotNull
    public WorldConfig createWorldConfig(@NotNull String worldName) {
        Validate.notNull((Object)worldName, (String)"World name can not be null");
        Validate.notEmpty((String)worldName, (String)"World name can not be empty");
        return this.getWorldConfig(worldName).orElseGet(() -> new WorldConfigYamlImpl(worldName));
    }

    @Override
    @NotNull
    public OreConfig createOreConfig(@NotNull String name, @NotNull Material material, @NotNull OreGenerator oreGenerator, @NotNull BlockSelector blockSelector) {
        Validate.notNull((Object)name, (String)"OreConfig name can not be null");
        Validate.notNull((Object)material, (String)"Material can not be null");
        Validate.notNull((Object)oreGenerator, (String)"OreGenerator can not be null");
        Validate.notNull((Object)blockSelector, (String)"BlockSelector can not be null");
        Validate.notEmpty((String)name, (String)"OreConfig name can not be null");
        Validate.isTrue((boolean)material.isBlock(), (String)("Material " + material + " is not a block"));
        Validate.isTrue((boolean)this.getOreGenerator(oreGenerator.getName()).isPresent(), (String)("OreGenerator " + oreGenerator.getName() + " is not registered"));
        Validate.isTrue((boolean)this.getBlockSelector(blockSelector.getName()).isPresent(), (String)("BlockSelector " + blockSelector.getName() + " is not registered"));
        Validate.isTrue((boolean)ORE_CONFIG_NAME_PATTERN.matcher(name).matches(), (String)("OreConfig name " + name + " does not match the regex: ^[a-zA-Z0-9_-]*$"));
        return new OreConfigYamlImpl(name, material, oreGenerator.getName(), blockSelector.getName());
    }

    @Override
    public void saveOreConfig(@NotNull OreConfig config) {
        Validate.notNull((Object)config, (String)"OreConfig can not be null");
        this.oreConfigDao.save(config);
    }

    @Override
    @NotNull
    public Set<OreConfig> getOreConfigs() {
        return this.oreConfigDao.getAll();
    }

    @Override
    public void saveWorldConfig(@NotNull WorldConfig config) {
        Validate.notNull((Object)config, (String)"WorldConfig can not be null");
        this.worldConfigDao.save(config);
    }

    @Override
    @NotNull
    public Set<WorldConfig> getWorldConfigs() {
        return this.worldConfigDao.getAll();
    }

    @Override
    @NotNull
    public Optional<OreConfig> getOreConfig(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can not be null");
        Validate.notEmpty((String)name, (String)"Name can not be empty");
        return this.oreConfigDao.get(name);
    }

    @Override
    @NotNull
    public Random createRandom(long seed, int x, int z) {
        Random random = new Random(seed);
        long long1 = random.nextLong();
        long long2 = random.nextLong();
        long newSeed = (long)x * long1 ^ (long)z * long2 ^ seed;
        random.setSeed(newSeed);
        return random;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    static {
        CUSTOM_DATA_NAME_PATTERN = ORE_GENERATOR_NAME_PATTERN = (BLOCK_SELECTOR_NAME_PATTERN = Pattern.compile("^[A-Z_]*$"));
        ORE_CONFIG_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]*$");
    }
}

