/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.listeners;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.listeners.MaterialListener;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ReplaceMaterialListener
extends MaterialListener {
    private final MessageKey alreadyAdd;
    private final MessageKey add;
    private final MessageKey notAdd;
    private final MessageKey remove;

    public ReplaceMaterialListener(@NotNull JavaPlugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull Player player, @NotNull OreConfigBuilder oreConfigBuilder, @NotNull Conversation conversation) {
        super(plugin, serviceSupplier, player, oreConfigBuilder, conversation);
        this.alreadyAdd = new MessageKey((Plugin)plugin, "ore-config.factory.replace-material.already-add");
        this.add = new MessageKey((Plugin)plugin, "ore-config.factory.replace-material.add");
        this.notAdd = new MessageKey((Plugin)plugin, "ore-config.factory.replace-material.not-add");
        this.remove = new MessageKey((Plugin)plugin, "ore-config.factory.replace-material.remove");
    }

    @Override
    public void onAirLeftClick() {
        OreConfigBuilder oreConfigBuilder = this.getOreConfigBuilder();
        if (oreConfigBuilder.containsReplaceMaterial(Material.AIR)) {
            this.alreadyAdd.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", Material.AIR));
            return;
        }
        oreConfigBuilder.addReplaceMaterial(Material.AIR);
        this.add.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", Material.AIR));
    }

    @Override
    public void onAirShiftLeftClick() {
        OreConfigBuilder oreConfigBuilder = this.getOreConfigBuilder();
        if (!oreConfigBuilder.containsReplaceMaterial(Material.AIR)) {
            this.notAdd.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", Material.AIR));
            return;
        }
        oreConfigBuilder.removeReplaceMaterial(Material.AIR);
        this.remove.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", Material.AIR));
    }

    @Override
    public void onBlockLeftClick(@NotNull Block block) {
        Material material = block.getType();
        OreConfigBuilder oreConfigBuilder = this.getOreConfigBuilder();
        if (oreConfigBuilder.containsReplaceMaterial(material)) {
            this.alreadyAdd.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", material));
            return;
        }
        oreConfigBuilder.addReplaceMaterial(material);
        this.add.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", material));
    }

    @Override
    public void onBlockShiftLeftClick(@NotNull Block block) {
        Material material = block.getType();
        OreConfigBuilder oreConfigBuilder = this.getOreConfigBuilder();
        if (!oreConfigBuilder.containsReplaceMaterial(material)) {
            this.notAdd.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", material));
            return;
        }
        oreConfigBuilder.removeReplaceMaterial(material);
        this.remove.sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", material));
    }
}

