/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.listeners;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Block;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MaterialListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final Player player;
    @NotNull
    private final OreConfigBuilder oreConfigBuilder;
    @NotNull
    private final Conversation conversation;

    public MaterialListener(@NotNull JavaPlugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull Player player, @NotNull OreConfigBuilder oreConfigBuilder, @NotNull Conversation conversation) {
        Validate.notNull((Object)plugin, (String)"JavaPlugin can not be null");
        Validate.notNull(serviceSupplier, (String)"Service Supplier can not be null");
        Validate.notNull((Object)player, (String)"Player can not be null");
        Validate.notNull((Object)oreConfigBuilder, (String)"OreConfigBuilder can not be null");
        Validate.notNull((Object)conversation, (String)"Conversation can not be null");
        this.plugin = plugin;
        this.serviceSupplier = serviceSupplier;
        this.player = player;
        this.oreConfigBuilder = oreConfigBuilder;
        this.conversation = conversation;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.conversation.addConversationAbandonedListener(event -> this.destroy());
    }

    @EventHandler
    public void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        event.setCancelled(true);
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            if (this.player.isSneaking()) {
                this.onBlockShiftLeftClick(event.getClickedBlock());
            } else {
                this.onBlockLeftClick(event.getClickedBlock());
            }
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR) {
            if (this.player.isSneaking()) {
                this.onAirShiftLeftClick();
            } else {
                this.onAirLeftClick();
            }
            return;
        }
    }

    public void onBlockLeftClick(@NotNull Block block) {
    }

    public void onBlockShiftLeftClick(@NotNull Block block) {
    }

    public void onAirLeftClick() {
    }

    public void onAirShiftLeftClick() {
    }

    @EventHandler
    public void onPlayerLeave(@NotNull PlayerQuitEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        this.destroy();
    }

    public void destroy() {
        PlayerInteractEvent.getHandlerList().unregister((Listener)this);
        PlayerQuitEvent.getHandlerList().unregister((Listener)this);
    }

    public OreConfigBuilder getOreConfigBuilder() {
        return this.oreConfigBuilder;
    }

    public Conversation getConversation() {
        return this.conversation;
    }

    public Player getPlayer() {
        return this.player;
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public Supplier<CustomOreGeneratorService> getServiceSupplier() {
        return this.serviceSupplier;
    }
}

