/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.listeners;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.listeners.MaterialListener;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MainMaterialListener
extends MaterialListener {
    public MainMaterialListener(@NotNull JavaPlugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull Player player, @NotNull OreConfigBuilder oreConfigBuilder, @NotNull Conversation conversation) {
        super(plugin, serviceSupplier, player, oreConfigBuilder, conversation);
    }

    @Override
    public void onAirLeftClick() {
        this.getOreConfigBuilder().material(Material.AIR);
        new MessageKey((Plugin)this.getPlugin(), "ore-config.factory.material.set").sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", Material.AIR));
    }

    @Override
    public void onBlockLeftClick(@NotNull Block block) {
        this.getOreConfigBuilder().material(block.getType());
        this.getOreConfigBuilder().foundCustomDatas().clear();
        BlockState blockState = block.getState();
        this.getServiceSupplier().get().getCustomData().stream().filter(customData -> customData.hasCustomData(blockState)).forEach(customData -> this.getOreConfigBuilder().setFoundCustomData((CustomData)customData, customData.getCustomData(blockState)));
        new MessageKey((Plugin)this.getPlugin(), "ore-config.factory.material.set").sendMessage((CommandSender)this.getPlayer(), new MessageValue("material", block.getType()));
    }
}

