/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.listeners;

import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CommandListener
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Player player;
    @NotNull
    private final Conversation conversation;

    public CommandListener(@NotNull Plugin plugin, @NotNull Player player, @NotNull Conversation conversation) {
        Validate.notNull((Object)plugin, (String)"plugin can not be null");
        Validate.notNull((Object)player, (String)"Player can not be null");
        Validate.notNull((Object)conversation, (String)"Conversation can not be null");
        this.plugin = plugin;
        this.player = player;
        this.conversation = conversation;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
        this.conversation.addConversationAbandonedListener(event -> this.destroy());
    }

    @EventHandler
    public void onPlayerCommandPreprocess(@NotNull PlayerCommandPreprocessEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        new MessageKey(this.plugin, "ore-config.factory.command-blocked").sendMessage((CommandSender)this.player, new MessageValue[0]);
        event.setCancelled(true);
    }

    @EventHandler
    public void onTabComplete(@NotNull TabCompleteEvent event) {
        if (event.getSender() != this.player) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerLeave(@NotNull PlayerQuitEvent event) {
        if (event.getPlayer() != this.player) {
            return;
        }
        this.destroy();
    }

    public void destroy() {
        PlayerCommandPreprocessEvent.getHandlerList().unregister((Listener)this);
        TabCompleteEvent.getHandlerList().unregister((Listener)this);
        PlayerQuitEvent.getHandlerList().unregister((Listener)this);
    }
}

