/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui.settings;

import de.derfrzocker.custom.ore.generator.utils.gui.BasicSettings;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OreSettingGuiSettings
extends BasicSettings {
    public OreSettingGuiSettings(@NotNull Plugin plugin, @NotNull String file) {
        super(plugin, file);
    }

    public OreSettingGuiSettings(@NotNull Plugin plugin, @NotNull String file, boolean copy) {
        super(plugin, file, copy);
    }

    public OreSettingGuiSettings(@NotNull Plugin plugin, @NotNull Supplier<ConfigurationSection> configurationSectionSupplier) {
        super(plugin, configurationSectionSupplier);
    }

    @NotNull
    public ItemStack getMenuItemStack() {
        return this.getSection().getItemStack("menu.item-stack").clone();
    }

    public int getMenuSlot() {
        return this.getSection().getInt("menu.slot");
    }

    @NotNull
    public ItemStack getAbortItemStack() {
        return this.getSection().getItemStack("abort.item-stack").clone();
    }

    public int getAbortSlot() {
        return this.getSection().getInt("abort.slot");
    }

    @NotNull
    public ItemStack getBackItemStack() {
        return this.getSection().getItemStack("back.item-stack").clone();
    }

    public int getBackSlot() {
        return this.getSection().getInt("back.slot");
    }

    @NotNull
    public ItemStack getOreSettingItemStack() {
        return this.getSection().getItemStack("ore-setting.item-stack").clone();
    }

    public int getOreSettingSlot() {
        return this.getSection().getInt("ore-setting.slot");
    }

    @NotNull
    public Set<ItemStackValues> getItemStackValues() {
        HashSet<ItemStackValues> set = new HashSet<ItemStackValues>();
        this.getSection().getConfigurationSection("items").getKeys(false).stream().map(value -> this.getSection().getConfigurationSection("items." + value)).map(value -> new ItemStackValues(value.getInt("slot", 0), value.getDouble("value", 0.0), value.getItemStack("item-stack").clone())).forEach(set::add);
        return set;
    }

    public static final class ItemStackValues {
        private final int slot;
        private final double value;
        @NotNull
        private final ItemStack itemStack;

        private ItemStackValues(int slot, double value, @NotNull ItemStack itemStack) {
            this.slot = slot;
            this.value = value;
            this.itemStack = itemStack;
        }

        public int getSlot() {
            return this.slot;
        }

        public double getValue() {
            return this.value;
        }

        @NotNull
        public ItemStack getItemStack() {
            return this.itemStack;
        }
    }
}

