/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui.settings;

import de.derfrzocker.custom.ore.generator.utils.gui.PageSettings;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BiomeGuiSettings
extends PageSettings {
    private final Plugin plugin;

    public BiomeGuiSettings(@NotNull Plugin plugin, @NotNull String file) {
        super(plugin, file);
        this.plugin = plugin;
    }

    public BiomeGuiSettings(@NotNull Plugin plugin, @NotNull String file, boolean copy) {
        super(plugin, file, copy);
        this.plugin = plugin;
    }

    public BiomeGuiSettings(@NotNull Plugin plugin, @NotNull Supplier<ConfigurationSection> configurationSectionSupplier) {
        super(plugin, configurationSectionSupplier);
        this.plugin = plugin;
    }

    @NotNull
    public ItemStack getMenuItemStack() {
        return this.getSection().getItemStack("menu.item-stack").clone();
    }

    public int getMenuSlot() {
        return this.getSection().getInt("menu.slot");
    }

    @NotNull
    public ItemStack getAbortItemStack() {
        return this.getSection().getItemStack("abort.item-stack").clone();
    }

    public int getAbortSlot() {
        return this.getSection().getInt("abort.slot");
    }

    @NotNull
    public ItemStack getDeactivatedItemStack() {
        return this.getSection().getItemStack("deactivate.item-stack").clone();
    }

    @NotNull
    public ItemStack getActivatedItemStack() {
        return this.getSection().getItemStack("activate.item-stack").clone();
    }

    @NotNull
    public Material getBiomeMaterial(@NotNull String biome) {
        String value = this.getSection().getString("biomes." + biome);
        if (value == null) {
            this.plugin.getLogger().warning("There is no material for the biome " + biome + " using default Material " + Material.STONE);
            return Material.STONE;
        }
        return Material.valueOf((String)value);
    }

    @NotNull
    public ItemStack getNextItemStack() {
        return this.getSection().getItemStack("next.item-stack").clone();
    }

    public int getNextSlot() {
        return this.getSection().getInt("next.slot");
    }
}

