/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.WorldGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.PageGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WorldGui
extends PageGui<World> {
    private static WorldGuiSettings worldGuiSettings;
    @NotNull
    private final OreConfigFactory oreConfigFactory;

    public WorldGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer) {
        super(plugin, WorldGui.checkSettings(plugin));
        Validate.notNull((Object)oreConfigFactory, (String)"OreConfigFactory can not be null");
        this.oreConfigFactory = oreConfigFactory;
        this.addDecorations(new MessageValue[0]);
        this.init(Bukkit.getWorlds().toArray(new World[0]), World[]::new, this::getItemStack, this::handleNormalClick);
        this.addItem(worldGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, worldGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(worldGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, worldGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(worldGuiSettings.getNextSlot(), MessageUtil.replaceItemStack(plugin, worldGuiSettings.getNextItemStack(), new MessageValue[0]), inventoryClickEvent -> consumer.accept(oreConfigFactory));
    }

    private static WorldGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (worldGuiSettings == null) {
            worldGuiSettings = new WorldGuiSettings(plugin, "data/factory/gui/world-gui.yml", true);
        }
        return worldGuiSettings;
    }

    private ItemStack getItemStack(@NotNull World world) {
        ItemStack itemStack = this.oreConfigFactory.getOreConfigBuilder().containsWorld(world) ? worldGuiSettings.getActivatedItemStack() : worldGuiSettings.getDeactivatedItemStack();
        return MessageUtil.replaceItemStack(this.getPlugin(), itemStack, new MessageValue("name", world.getName()));
    }

    private void handleNormalClick(@NotNull World world, @NotNull InventoryClickEvent event) {
        OreConfigBuilder oreConfigBuilder = this.oreConfigFactory.getOreConfigBuilder();
        if (oreConfigBuilder.containsWorld(world)) {
            oreConfigBuilder.removeWorld(world);
        } else {
            oreConfigBuilder.addWorld(world);
        }
        this.updateItemStack(world, this.getItemStack(world));
    }
}

