/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import de.derfrzocker.custom.ore.generator.api.OreSettingsAble;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.OreSettingGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.OreSettingsGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.PageGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OreSettingsGui
extends PageGui<OreSetting> {
    private static OreSettingsGuiSettings oreSettingsGuiSettings;
    @NotNull
    private final OreSettingsAble oreSettingsAble;

    public OreSettingsGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer, @NotNull OreSettingsAble oreSettingsAble, @NotNull OreSettingContainer oreSettingContainer) {
        super(plugin, OreSettingsGui.checkSettings(plugin));
        this.oreSettingsAble = oreSettingsAble;
        OreConfigBuilder oreConfigBuilder = oreConfigFactory.getOreConfigBuilder();
        OreGenerator oreGenerator = oreConfigBuilder.oreGenerator();
        BlockSelector blockSelector = oreConfigBuilder.blockSelector();
        Set<OreSetting> settings = oreSettingsAble.getNeededOreSettings();
        if (settings.isEmpty()) {
            throw new IllegalStateException("Cant create OreSettingsGui with out settings");
        }
        this.addDecorations(new MessageValue[0]);
        this.init(settings.toArray(new OreSetting[0]), OreSetting[]::new, this::getItemStack, (oreSetting, inventoryClickEvent) -> new OreSettingGui(this.getPlugin(), serviceSupplier, oreConfigFactory, consumer, (OreSetting)oreSetting, oreSettingsAble, oreSettingContainer).openSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(oreSettingsGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, oreSettingsGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(oreSettingsGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, oreSettingsGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(oreSettingsGuiSettings.getNextSlot(), MessageUtil.replaceItemStack(plugin, oreSettingsGuiSettings.getNextItemStack(), new MessageValue[0]), inventoryClickEvent -> consumer.accept(oreConfigFactory));
    }

    private static OreSettingsGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (oreSettingsGuiSettings == null) {
            oreSettingsGuiSettings = new OreSettingsGuiSettings(plugin, "data/factory/gui/ore-settings-gui.yml", true);
        }
        return oreSettingsGuiSettings;
    }

    private ItemStack getItemStack(@NotNull OreSetting oreSetting) {
        ItemStack itemStack = oreSettingsGuiSettings.getOreSettingItemStack();
        itemStack.setType(this.oreSettingsAble.getOreSettingInfo(oreSetting).getMaterial());
        return MessageUtil.replaceItemStack(this.getPlugin(), itemStack, new MessageValue("name", this.oreSettingsAble.getOreSettingInfo(oreSetting).getDisplayName()));
    }
}

