/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import de.derfrzocker.custom.ore.generator.api.OreSettingsAble;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.OreSettingsGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.OreSettingGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.BasicGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OreSettingGui
extends BasicGui {
    private static OreSettingGuiSettings oreSettingGuiSettings;
    private final OreSetting oreSetting;
    private final OreConfigBuilder oreConfigBuilder;
    private final OreSettingsAble oreSettingsAble;
    private final OreSettingContainer oreSettingContainer;
    private final int oreSettingSlot;

    public OreSettingGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer, @NotNull OreSetting oreSetting, @NotNull OreSettingsAble oreSettingsAble, @NotNull OreSettingContainer oreSettingContainer) {
        super(plugin, OreSettingGui.checkSettings(plugin));
        this.oreSetting = oreSetting;
        this.oreConfigBuilder = oreConfigFactory.getOreConfigBuilder();
        this.oreSettingsAble = oreSettingsAble;
        this.oreSettingContainer = oreSettingContainer;
        this.oreSettingSlot = oreSettingGuiSettings.getOreSettingSlot();
        this.addDecorations(new MessageValue[0]);
        this.addItem(oreSettingGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, oreSettingGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(oreSettingGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, oreSettingGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(oreSettingGuiSettings.getBackSlot(), MessageUtil.replaceItemStack(plugin, oreSettingGuiSettings.getBackItemStack(), new MessageValue[0]), inventoryClickEvent -> new OreSettingsGui(plugin, serviceSupplier, oreConfigFactory, consumer, oreSettingsAble, oreSettingContainer).openSync(inventoryClickEvent.getWhoClicked()));
        Double tempCurrent = oreSettingContainer.getValue(oreSetting).orElse(0.0);
        this.updateItemStack(tempCurrent);
        oreSettingGuiSettings.getItemStackValues().forEach(value -> this.addItem(value.getSlot(), value.getItemStack(), new SettingConsumer(value.getValue())));
    }

    private static OreSettingGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (oreSettingGuiSettings == null) {
            oreSettingGuiSettings = new OreSettingGuiSettings(plugin, "data/factory/gui/ore-setting-gui.yml", true);
        }
        return oreSettingGuiSettings;
    }

    private void updateItemStack(double value) {
        ItemStack itemStack = oreSettingGuiSettings.getOreSettingItemStack();
        itemStack.setType(this.oreSettingsAble.getOreSettingInfo(this.oreSetting).getMaterial());
        this.addItem(this.oreSettingSlot, MessageUtil.replaceItemStack(this.getPlugin(), itemStack, new MessageValue("value", value), new MessageValue("name", this.oreSettingsAble.getOreSettingInfo(this.oreSetting).getDisplayName())));
    }

    private final class SettingConsumer
    implements Consumer<InventoryClickEvent> {
        private final double value;

        private SettingConsumer(double value) {
            this.value = value;
        }

        @Override
        public void accept(@NotNull InventoryClickEvent event) {
            if (event.getClick() != ClickType.LEFT) {
                return;
            }
            double current = OreSettingGui.this.oreSettingContainer.getValue(OreSettingGui.this.oreSetting).orElse(0.0);
            double newValue = Double.parseDouble(String.format(Locale.ENGLISH, "%1.2f", current + this.value));
            OreSettingGui.this.oreSettingContainer.setValue(OreSettingGui.this.oreSetting, newValue);
            OreSettingGui.this.updateItemStack(newValue);
        }
    }
}

