/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.OreGeneratorGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.PageGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OreGeneratorGui
extends PageGui<OreGenerator> {
    private static OreGeneratorGuiSettings oreGeneratorGuiSettings;

    public OreGeneratorGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer) {
        super(plugin, OreGeneratorGui.checkSettings(plugin));
        CustomOreGeneratorService service = serviceSupplier.get();
        OreGenerator defaultOreGenerator = service.getDefaultOreGenerator();
        OreGenerator[] oreGenerators = service.getOreGenerators().toArray(new OreGenerator[0]);
        this.addDecorations(new MessageValue[0]);
        this.init(oreGenerators, OreGenerator[]::new, this::getItemStack, (oreGenerator, inventoryClickEvent) -> {
            oreConfigFactory.getOreConfigBuilder().oreGenerator((OreGenerator)oreGenerator);
            consumer.accept(oreConfigFactory);
        });
        this.addItem(oreGeneratorGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, oreGeneratorGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(oreGeneratorGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, oreGeneratorGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        if (defaultOreGenerator != null) {
            this.addItem(oreGeneratorGuiSettings.getDefaultOreGeneratorSlot(), MessageUtil.replaceItemStack(plugin, oreGeneratorGuiSettings.getDefaultOreGeneratorItemStack(), new MessageValue("description", defaultOreGenerator.getInfo().getDescription()), new MessageValue("name", defaultOreGenerator.getName()), new MessageValue("display-name", defaultOreGenerator.getInfo().getDisplayName())), inventoryClickEvent -> {
                oreConfigFactory.getOreConfigBuilder().oreGenerator(defaultOreGenerator);
                consumer.accept(oreConfigFactory);
            });
        }
    }

    private static OreGeneratorGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (oreGeneratorGuiSettings == null) {
            oreGeneratorGuiSettings = new OreGeneratorGuiSettings(plugin, "data/factory/gui/ore-generator-gui.yml", true);
        }
        return oreGeneratorGuiSettings;
    }

    private ItemStack getItemStack(@NotNull OreGenerator oreGenerator) {
        ItemStack itemStack = oreGeneratorGuiSettings.getOreGeneratorItemStack();
        itemStack.setType(oreGenerator.getInfo().getMaterial());
        return MessageUtil.replaceItemStack(this.getPlugin(), itemStack, new MessageValue("description", oreGenerator.getInfo().getDescription()), new MessageValue("name", oreGenerator.getName()), new MessageValue("display-name", oreGenerator.getInfo().getDisplayName()));
    }
}

