/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.MenuGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.BasicGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MenuGui
extends BasicGui {
    private static MenuGuiSettings menuGuiSettings;
    private boolean ready = true;

    public MenuGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory) {
        super(plugin, MenuGui.checkSettings(plugin));
        ItemStack itemStack;
        this.addDecorations(new MessageValue[0]);
        OreConfigBuilder oreConfigBuilder = oreConfigFactory.getOreConfigBuilder();
        String name = oreConfigBuilder.name();
        LinkedHashSet<MessageValue> messageValues = new LinkedHashSet<MessageValue>();
        messageValues.add(new MessageValue("step", "name"));
        if (name != null) {
            itemStack = menuGuiSettings.getStatusPresentItemStack();
            messageValues.add(new MessageValue("name", name));
        } else {
            this.ready = false;
            itemStack = menuGuiSettings.getStatusNeededItemStack();
        }
        this.addItem(menuGuiSettings.getStepNameSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> {
            this.closeSync(inventoryClickEvent.getWhoClicked());
            oreConfigFactory.setName(arg_0 -> MenuGui.lambda$new$0(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0));
        });
        Material material = oreConfigBuilder.material();
        messageValues = new LinkedHashSet();
        messageValues.add(new MessageValue("step", "material"));
        if (material != null) {
            itemStack = menuGuiSettings.getStatusPresentItemStack();
            messageValues.add(new MessageValue("material", material));
        } else {
            this.ready = false;
            itemStack = menuGuiSettings.getStatusNeededItemStack();
        }
        this.addItem(menuGuiSettings.getStepMaterialSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> {
            this.closeSync(inventoryClickEvent.getWhoClicked());
            oreConfigFactory.setMaterial(arg_0 -> MenuGui.lambda$new$2(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0));
        });
        Set<Material> replaceMaterial = oreConfigBuilder.replaceMaterial();
        messageValues = new LinkedHashSet();
        messageValues.add(new MessageValue("step", "replace-material"));
        if (!replaceMaterial.isEmpty()) {
            itemStack = menuGuiSettings.getStatusPresentItemStack();
        } else {
            this.ready = false;
            itemStack = menuGuiSettings.getStatusNeededItemStack();
        }
        this.addItem(menuGuiSettings.getStepReplaceMaterialsSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> {
            this.closeSync(inventoryClickEvent.getWhoClicked());
            oreConfigFactory.setReplaceMaterials(arg_0 -> MenuGui.lambda$new$4(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0));
        });
        Set<Material> selectMaterial = oreConfigBuilder.selectMaterial();
        messageValues = new LinkedHashSet();
        messageValues.add(new MessageValue("step", "select-material"));
        itemStack = !selectMaterial.isEmpty() ? menuGuiSettings.getStatusPresentItemStack() : menuGuiSettings.getStatusNotPresentNotNeededItemStack();
        this.addItem(menuGuiSettings.getStepSelectMaterialsSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> {
            this.closeSync(inventoryClickEvent.getWhoClicked());
            oreConfigFactory.setSelectMaterials(arg_0 -> MenuGui.lambda$new$6(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0));
        });
        OreGenerator oreGenerator = oreConfigBuilder.oreGenerator();
        messageValues = new LinkedHashSet();
        messageValues.add(new MessageValue("step", "ore-generator"));
        if (oreGenerator != null) {
            itemStack = menuGuiSettings.getStatusPresentItemStack();
            messageValues.add(new MessageValue("ore-generator", oreGenerator.getName()));
        } else {
            this.ready = false;
            itemStack = menuGuiSettings.getStatusNeededItemStack();
        }
        this.addItem(menuGuiSettings.getStepOreGeneratorSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> oreConfigFactory.setOreGenerator(arg_0 -> MenuGui.lambda$new$8(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0)));
        BlockSelector blockSelector = oreConfigBuilder.blockSelector();
        messageValues = new LinkedHashSet();
        messageValues.add(new MessageValue("step", "block-selector"));
        if (blockSelector != null) {
            itemStack = menuGuiSettings.getStatusPresentItemStack();
            messageValues.add(new MessageValue("block-selector", blockSelector.getName()));
        } else {
            this.ready = false;
            itemStack = menuGuiSettings.getStatusNeededItemStack();
        }
        this.addItem(menuGuiSettings.getStepBlockSelectorSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> oreConfigFactory.setBlockSelector(arg_0 -> MenuGui.lambda$new$10(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0)));
        Set<Biome> biomes = oreConfigBuilder.biomes();
        messageValues = new LinkedHashSet();
        messageValues.add(new MessageValue("step", "biome"));
        itemStack = !biomes.isEmpty() ? menuGuiSettings.getStatusPresentItemStack() : menuGuiSettings.getStatusNotPresentNotNeededItemStack();
        this.addItem(menuGuiSettings.getStepBiomeSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> oreConfigFactory.setBiomes(arg_0 -> MenuGui.lambda$new$12(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0)));
        Map<OreSetting, Double> oreSettings = oreConfigBuilder.getOreGeneratorOreSettings().getValues();
        messageValues = new LinkedHashSet();
        boolean setAction = true;
        messageValues.add(new MessageValue("step", "ore-generator-ore-setting"));
        OreGenerator oreGenerator2 = oreConfigBuilder.oreGenerator();
        if (oreGenerator2 == null) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            setAction = false;
        } else if (!oreGenerator2.getNeededOreSettings().isEmpty()) {
            itemStack = oreSettings.isEmpty() ? menuGuiSettings.getStatusNotPresentNotNeededItemStack() : menuGuiSettings.getStatusPresentItemStack();
        } else {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            setAction = false;
        }
        if (setAction) {
            this.addItem(menuGuiSettings.getStepOreGeneratorOreSettingsSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> oreConfigFactory.setOreGeneratorOreSettings(arg_0 -> MenuGui.lambda$new$14(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0)));
        } else {
            this.addItem(menuGuiSettings.getStepOreGeneratorOreSettingsSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])));
        }
        oreSettings = oreConfigBuilder.getBlockSelectorOreSettings().getValues();
        messageValues = new LinkedHashSet();
        setAction = true;
        messageValues.add(new MessageValue("step", "block-selector-ore-setting"));
        BlockSelector blockSelector2 = oreConfigBuilder.blockSelector();
        if (blockSelector2 == null) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            setAction = false;
        } else if (!blockSelector2.getNeededOreSettings().isEmpty()) {
            itemStack = oreSettings.isEmpty() ? menuGuiSettings.getStatusNotPresentNotNeededItemStack() : menuGuiSettings.getStatusPresentItemStack();
        } else {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            setAction = false;
        }
        if (setAction) {
            this.addItem(menuGuiSettings.getStepBlockSelectorOreSettingsSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> oreConfigFactory.setBlockSelectorOreSettings(arg_0 -> MenuGui.lambda$new$16(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0)));
        } else {
            this.addItem(menuGuiSettings.getStepBlockSelectorOreSettingsSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])));
        }
        Map<CustomData, Object> customDatas = oreConfigBuilder.customDatas();
        messageValues = new LinkedHashSet();
        boolean customDataReady = true;
        messageValues.add(new MessageValue("step", "custom-data"));
        if (!customDatas.isEmpty()) {
            itemStack = menuGuiSettings.getStatusPresentItemStack();
        } else if (oreConfigBuilder.foundCustomDatas().isEmpty()) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            customDataReady = false;
        } else if (oreConfigBuilder.name() == null) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            customDataReady = false;
        } else if (oreConfigBuilder.material() == null) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            customDataReady = false;
        } else if (oreConfigBuilder.replaceMaterial().isEmpty()) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            customDataReady = false;
        } else if (oreConfigBuilder.oreGenerator() == null) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            customDataReady = false;
        } else if (oreConfigBuilder.blockSelector() == null) {
            itemStack = menuGuiSettings.getStatusNotSetAbleItemStack();
            customDataReady = false;
        } else {
            itemStack = menuGuiSettings.getStatusNotPresentNotNeededItemStack();
        }
        if (customDataReady) {
            this.addItem(menuGuiSettings.getStepCustomDatasSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> oreConfigFactory.setCustomDatas(arg_0 -> MenuGui.lambda$new$18(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0)));
        } else {
            this.addItem(menuGuiSettings.getStepCustomDatasSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])));
        }
        Set<World> worlds = oreConfigBuilder.worlds();
        messageValues = new LinkedHashSet();
        messageValues.add(new MessageValue("step", "world"));
        itemStack = !worlds.isEmpty() ? menuGuiSettings.getStatusPresentItemStack() : menuGuiSettings.getStatusNotPresentNotNeededItemStack();
        this.addItem(menuGuiSettings.getStepWorldSlot(), MessageUtil.replaceItemStack(plugin, itemStack, messageValues.toArray(new MessageValue[0])), inventoryClickEvent -> oreConfigFactory.setWorlds(arg_0 -> MenuGui.lambda$new$20(plugin, (Supplier)serviceSupplier, oreConfigFactory, arg_0)));
        if (this.ready) {
            this.addItem(menuGuiSettings.getOreConfigItemStackSlot(), MessageUtil.replaceItemStack(plugin, menuGuiSettings.getOreConfigReadyItemStack(), new MessageValue[0]), inventoryClickEvent -> {
                CustomOreGeneratorService service = (CustomOreGeneratorService)serviceSupplier.get();
                OreConfig oreConfig = service.createOreConfig(oreConfigBuilder.name(), oreConfigBuilder.material(), oreConfigBuilder.oreGenerator(), oreConfigBuilder.blockSelector());
                oreConfigBuilder.replaceMaterial().forEach(oreConfig::addReplaceMaterial);
                oreConfigBuilder.selectMaterial().forEach(oreConfig::addSelectMaterial);
                oreConfigBuilder.biomes().forEach(oreConfig::addBiome);
                if (oreConfigBuilder.biomes().size() != 0) {
                    oreConfig.setGeneratedAll(false);
                }
                oreConfigBuilder.getOreGeneratorOreSettings().getValues().forEach((oreSetting, aDouble) -> oreConfig.getOreGeneratorOreSettings().setValue((OreSetting)oreSetting, (double)aDouble));
                oreConfigBuilder.getBlockSelectorOreSettings().getValues().forEach((oreSetting, aDouble) -> oreConfig.getBlockSelectorOreSettings().setValue((OreSetting)oreSetting, (double)aDouble));
                oreConfigBuilder.customDatas().forEach(oreConfig::setCustomData);
                service.saveOreConfig(oreConfig);
                for (World world : oreConfigBuilder.worlds()) {
                    WorldConfig worldConfig = service.createWorldConfig(world);
                    worldConfig.addOreConfig(oreConfig);
                    service.saveWorldConfig(worldConfig);
                }
                this.closeSync(inventoryClickEvent.getWhoClicked());
                oreConfigFactory.setRunning(false);
                new MessageKey(this.getPlugin(), "ore-config.factory.success").sendMessage((CommandSender)inventoryClickEvent.getWhoClicked(), new MessageValue[0]);
            });
        } else {
            this.addItem(menuGuiSettings.getOreConfigItemStackSlot(), MessageUtil.replaceItemStack(plugin, menuGuiSettings.getOreConfigNotReadyItemStack(), new MessageValue[0]));
        }
        this.addItem(menuGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, menuGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
    }

    private static MenuGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (menuGuiSettings == null) {
            menuGuiSettings = new MenuGuiSettings(plugin, "data/factory/gui/menu-gui.yml", true);
        }
        return menuGuiSettings;
    }

    private static /* synthetic */ void lambda$new$20(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$18(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$16(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$14(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$12(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$10(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$8(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$6(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$4(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$2(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }

    private static /* synthetic */ void lambda$new$0(Plugin plugin, Supplier serviceSupplier, OreConfigFactory oreConfigFactory, OreConfigFactory oreConfigFactory1) {
        new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync((HumanEntity)oreConfigFactory1.getPlayer());
    }
}

