/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.CustomDataGui;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.CustomDatasGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.PageGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CustomDatasGui
extends PageGui<CustomData> {
    private static CustomDatasGuiSettings customDatasGuiSettings;

    public CustomDatasGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer) {
        super(plugin, CustomDatasGui.checkSettings(plugin));
        Map<CustomData, Object> customDatas = oreConfigFactory.getOreConfigBuilder().customDatas();
        Map<CustomData, Object> foundCustomDatas = oreConfigFactory.getOreConfigBuilder().foundCustomDatas();
        LinkedHashSet<CustomData> allCustomDatas = new LinkedHashSet<CustomData>(customDatas.keySet());
        allCustomDatas.addAll(foundCustomDatas.keySet());
        this.addDecorations(new MessageValue[0]);
        this.init(allCustomDatas.toArray(new CustomData[0]), CustomData[]::new, customData -> {
            MessageValue[] messageValues = new MessageValue[]{new MessageValue("description", customData.getInfo().getDescription()), new MessageValue("name", customData.getName()), new MessageValue("display-name", customData.getInfo().getDisplayName())};
            ItemStack itemStack = customDatas.containsKey(customData) ? customDatasGuiSettings.getActivatedCustomDataItemStack() : customDatasGuiSettings.getDeactivatedCustomDataItemStack();
            itemStack.setType(customData.getInfo().getMaterial());
            return MessageUtil.replaceItemStack(this.getPlugin(), itemStack, messageValues);
        }, (customData, inventoryClickEvent) -> new CustomDataGui(plugin, serviceSupplier, oreConfigFactory, consumer, (CustomData)customData).openSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(customDatasGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, customDatasGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(customDatasGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, customDatasGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(customDatasGuiSettings.getNextSlot(), MessageUtil.replaceItemStack(plugin, customDatasGuiSettings.getNextItemStack(), new MessageValue[0]), inventoryClickEvent -> consumer.accept(oreConfigFactory));
    }

    private static CustomDatasGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (customDatasGuiSettings == null) {
            customDatasGuiSettings = new CustomDatasGuiSettings(plugin, "data/factory/gui/custom-datas-gui.yml", true);
        }
        return customDatasGuiSettings;
    }
}

