/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.CustomDatasGui;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.BooleanGuiSettings;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.CustomDataGuiSettings;
import de.derfrzocker.custom.ore.generator.factory.listeners.CommandListener;
import de.derfrzocker.custom.ore.generator.utils.gui.BasicGui;
import de.derfrzocker.custom.ore.generator.utils.gui.VerifyGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.ValidatingPrompt;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomDataGui
extends BasicGui {
    private static final MessageValue NOT_SET_MESSAGE_VALUE = new MessageValue("value", "<not set>");
    private static CustomDataGuiSettings customDataGuiSettings;
    private static BooleanGuiSettings booleanGuiSettings;
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final OreConfigFactory oreConfigFactory;
    @NotNull
    private final Consumer<OreConfigFactory> consumer;
    @NotNull
    private final CustomData customData;

    public CustomDataGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer, @NotNull CustomData customData) {
        super(plugin, CustomDataGui.checkSettings(plugin));
        MessageValue currentValue;
        this.serviceSupplier = serviceSupplier;
        this.oreConfigFactory = oreConfigFactory;
        this.consumer = consumer;
        this.customData = customData;
        this.addDecorations(new MessageValue[0]);
        if (oreConfigFactory.getOreConfigBuilder().customDatas().containsKey(customData)) {
            this.addItem(customDataGuiSettings.getRemoveCustomDataSlot(), MessageUtil.replaceItemStack(plugin, customDataGuiSettings.getRemoveCustomDataItemStack(), new MessageValue[0]), inventoryClickEvent -> {
                oreConfigFactory.getOreConfigBuilder().removeCustomData(customData);
                new CustomDatasGui(plugin, serviceSupplier, oreConfigFactory, consumer).openSync(inventoryClickEvent.getWhoClicked());
            });
            currentValue = new MessageValue("value", oreConfigFactory.getOreConfigBuilder().getCustomData(customData));
        } else {
            currentValue = NOT_SET_MESSAGE_VALUE;
        }
        this.addItem(customDataGuiSettings.getSetValueSlot(), MessageUtil.replaceItemStack(plugin, customDataGuiSettings.getSetValueItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            switch (customData.getCustomDataType()) {
                case STRING: 
                case INTEGER: 
                case DOUBLE: {
                    this.getChatInput((Player)inventoryClickEvent.getWhoClicked());
                    break;
                }
                case BOOLEAN: {
                    new VerifyGui(plugin, arg_0 -> CustomDataGui.lambda$new$1(oreConfigFactory, customData, plugin, (Supplier)serviceSupplier, consumer, inventoryClickEvent, arg_0), arg_0 -> CustomDataGui.lambda$new$2(oreConfigFactory, customData, plugin, (Supplier)serviceSupplier, consumer, inventoryClickEvent, arg_0), booleanGuiSettings).openSync(inventoryClickEvent.getWhoClicked());
                }
            }
        });
        this.addItem(customDataGuiSettings.getFoundValueSlot(), MessageUtil.replaceItemStack(plugin, customDataGuiSettings.getFoundValueItemStack(), new MessageValue("value", oreConfigFactory.getOreConfigBuilder().getFoundCustomData(customData))), inventoryClickEvent -> {
            oreConfigFactory.getOreConfigBuilder().setCustomData(customData, oreConfigFactory.getOreConfigBuilder().getFoundCustomData(customData));
            new CustomDatasGui(plugin, serviceSupplier, oreConfigFactory, consumer).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(customDataGuiSettings.getCurrentValueSlot(), MessageUtil.replaceItemStack(plugin, customDataGuiSettings.getCurrentValueItemStack(), currentValue));
        this.addItem(customDataGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, customDataGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(customDataGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, customDataGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(customDataGuiSettings.getBackSlot(), MessageUtil.replaceItemStack(plugin, customDataGuiSettings.getBackItemStack(), new MessageValue[0]), inventoryClickEvent -> new CustomDatasGui(plugin, serviceSupplier, oreConfigFactory, consumer).openSync(inventoryClickEvent.getWhoClicked()));
    }

    private static CustomDataGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (customDataGuiSettings == null) {
            customDataGuiSettings = new CustomDataGuiSettings(plugin, "data/factory/gui/custom-data-gui.yml", true);
        }
        if (booleanGuiSettings == null) {
            booleanGuiSettings = new BooleanGuiSettings(plugin, "data/factory/gui/boolean-gui.yml", true);
        }
        return customDataGuiSettings;
    }

    private void getChatInput(final @NotNull Player player) {
        final OreConfigBuilder oreConfigBuilder = this.oreConfigFactory.getOreConfigBuilder();
        final OreConfig oreConfig = this.serviceSupplier.get().createOreConfig(oreConfigBuilder.name(), oreConfigBuilder.material(), oreConfigBuilder.oreGenerator(), oreConfigBuilder.blockSelector());
        oreConfigBuilder.replaceMaterial().forEach(oreConfig::addReplaceMaterial);
        oreConfigBuilder.selectMaterial().forEach(oreConfig::addSelectMaterial);
        oreConfigBuilder.biomes().forEach(oreConfig::addBiome);
        if (oreConfigBuilder.biomes().size() != 0) {
            oreConfig.setGeneratedAll(false);
        }
        oreConfigBuilder.getOreGeneratorOreSettings().getValues().forEach((oreSetting, aDouble) -> oreConfig.getOreGeneratorOreSettings().setValue((OreSetting)oreSetting, (double)aDouble));
        oreConfigBuilder.getBlockSelectorOreSettings().getValues().forEach((oreSetting, aDouble) -> oreConfig.getBlockSelectorOreSettings().setValue((OreSetting)oreSetting, (double)aDouble));
        oreConfigBuilder.customDatas().forEach(oreConfig::setCustomData);
        this.closeSync((HumanEntity)player);
        Conversation conversation = new ConversationFactory(this.getPlugin()).withModality(false).withLocalEcho(false).withFirstPrompt((Prompt)new ValidatingPrompt(){

            protected boolean isInputValid(@NotNull ConversationContext conversationContext, @NotNull String text) {
                switch (CustomDataGui.this.customData.getCustomDataType()) {
                    case STRING: {
                        return CustomDataGui.this.customData.isValidCustomData(text, oreConfig);
                    }
                    case INTEGER: {
                        int number;
                        try {
                            number = Integer.parseInt(text);
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                        return CustomDataGui.this.customData.isValidCustomData(number, oreConfig);
                    }
                    case DOUBLE: {
                        double number;
                        try {
                            number = Double.parseDouble(text);
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                        return CustomDataGui.this.customData.isValidCustomData(number, oreConfig);
                    }
                    case BOOLEAN: {
                        if ("TRUE".equalsIgnoreCase(text)) {
                            return CustomDataGui.this.customData.isValidCustomData(true, oreConfig);
                        }
                        if ("FALSE".equalsIgnoreCase(text)) {
                            return CustomDataGui.this.customData.isValidCustomData(false, oreConfig);
                        }
                        return false;
                    }
                }
                return false;
            }

            @Nullable
            protected Prompt acceptValidatedInput(@NotNull ConversationContext conversationContext, @NotNull String value) {
                Object parsedValue;
                switch (CustomDataGui.this.customData.getCustomDataType()) {
                    case STRING: {
                        parsedValue = value;
                        break;
                    }
                    case INTEGER: {
                        parsedValue = Integer.parseInt(value);
                        break;
                    }
                    case DOUBLE: {
                        parsedValue = Double.parseDouble(value);
                        break;
                    }
                    case BOOLEAN: {
                        parsedValue = Boolean.parseBoolean(value);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Default case reached");
                    }
                }
                oreConfigBuilder.setCustomData(CustomDataGui.this.customData, parsedValue);
                new CustomDatasGui(CustomDataGui.this.getPlugin(), CustomDataGui.this.serviceSupplier, CustomDataGui.this.oreConfigFactory, CustomDataGui.this.consumer).openSync((HumanEntity)player);
                return END_OF_CONVERSATION;
            }

            protected String getFailedValidationText(ConversationContext context, String invalidInput) {
                return MessageUtil.replacePlaceHolder(CustomDataGui.this.getPlugin(), new MessageKey(CustomDataGui.this.getPlugin(), "ore-config.factory.gui.custom-data.set-value." + (Object)((Object)CustomDataGui.this.customData.getCustomDataType()) + ".not-valid").getMessage(new MessageValue[0]), new MessageValue("value", invalidInput));
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext conversationContext) {
                return new MessageKey(CustomDataGui.this.getPlugin(), "ore-config.factory.gui.custom-data.set-value." + (Object)((Object)CustomDataGui.this.customData.getCustomDataType()) + ".begin").getMessage(new MessageValue[0]);
            }
        }).buildConversation((Conversable)player);
        new CommandListener(this.getPlugin(), player, conversation);
        player.beginConversation(conversation);
    }

    private static /* synthetic */ void lambda$new$2(OreConfigFactory oreConfigFactory, CustomData customData, Plugin plugin, Supplier serviceSupplier, Consumer consumer, InventoryClickEvent inventoryClickEvent, InventoryClickEvent falseClickEvent) {
        oreConfigFactory.getOreConfigBuilder().setCustomData(customData, false);
        new CustomDatasGui(plugin, serviceSupplier, oreConfigFactory, consumer).openSync(inventoryClickEvent.getWhoClicked());
    }

    private static /* synthetic */ void lambda$new$1(OreConfigFactory oreConfigFactory, CustomData customData, Plugin plugin, Supplier serviceSupplier, Consumer consumer, InventoryClickEvent inventoryClickEvent, InventoryClickEvent trueClickEvent) {
        oreConfigFactory.getOreConfigBuilder().setCustomData(customData, true);
        new CustomDatasGui(plugin, serviceSupplier, oreConfigFactory, consumer).openSync(inventoryClickEvent.getWhoClicked());
    }
}

