/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.BlockSelectorGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.PageGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BlockSelectorGui
extends PageGui<BlockSelector> {
    private static BlockSelectorGuiSettings blockSelectorGuiSettings;

    public BlockSelectorGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer) {
        super(plugin, BlockSelectorGui.checkSettings(plugin));
        CustomOreGeneratorService service = serviceSupplier.get();
        BlockSelector defaultBlockSelector = service.getDefaultBlockSelector();
        BlockSelector[] blockSelectors = service.getBlockSelectors().toArray(new BlockSelector[0]);
        this.addDecorations(new MessageValue[0]);
        this.init(blockSelectors, BlockSelector[]::new, this::getItemStack, (blockSelector, inventoryClickEvent) -> {
            oreConfigFactory.getOreConfigBuilder().blockSelector((BlockSelector)blockSelector);
            consumer.accept(oreConfigFactory);
        });
        this.addItem(blockSelectorGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, blockSelectorGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(blockSelectorGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, blockSelectorGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        if (defaultBlockSelector != null) {
            this.addItem(blockSelectorGuiSettings.getDefaultBlockSelectorSlot(), MessageUtil.replaceItemStack(plugin, blockSelectorGuiSettings.getDefaultBlockSelectorItemStack(), new MessageValue("description", defaultBlockSelector.getInfo().getDescription()), new MessageValue("name", defaultBlockSelector.getName()), new MessageValue("display-name", defaultBlockSelector.getInfo().getDisplayName())), inventoryClickEvent -> {
                oreConfigFactory.getOreConfigBuilder().blockSelector(defaultBlockSelector);
                consumer.accept(oreConfigFactory);
            });
        }
    }

    private static BlockSelectorGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (blockSelectorGuiSettings == null) {
            blockSelectorGuiSettings = new BlockSelectorGuiSettings(plugin, "data/factory/gui/block-selector-gui.yml", true);
        }
        return blockSelectorGuiSettings;
    }

    private ItemStack getItemStack(@NotNull BlockSelector blockSelector) {
        ItemStack itemStack = blockSelectorGuiSettings.getBlockSelectorItemStack();
        itemStack.setType(blockSelector.getInfo().getMaterial());
        return MessageUtil.replaceItemStack(this.getPlugin(), itemStack, new MessageValue("description", blockSelector.getInfo().getDescription()), new MessageValue("name", blockSelector.getName()), new MessageValue("display-name", blockSelector.getInfo().getDisplayName()));
    }
}

