/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory.gui;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.settings.BiomeGuiSettings;
import de.derfrzocker.custom.ore.generator.utils.gui.PageGui;
import de.derfrzocker.custom.ore.generator.utils.message.MessageUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Biome;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BiomeGui
extends PageGui<Biome> {
    private static BiomeGuiSettings biomeGuiSettings;
    @NotNull
    private final OreConfigFactory oreConfigFactory;

    public BiomeGui(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull OreConfigFactory oreConfigFactory, @NotNull Consumer<OreConfigFactory> consumer) {
        super(plugin, BiomeGui.checkSettings(plugin));
        Validate.notNull((Object)oreConfigFactory, (String)"OreConfigFactory can not be null");
        this.oreConfigFactory = oreConfigFactory;
        this.addDecorations(new MessageValue[0]);
        this.init(Biome.values(), Biome[]::new, this::getItemStack, this::handleNormalClick);
        this.addItem(biomeGuiSettings.getMenuSlot(), MessageUtil.replaceItemStack(plugin, biomeGuiSettings.getMenuItemStack(), new MessageValue[0]), inventoryClickEvent -> {
            oreConfigFactory.setRunning(false);
            new MenuGui(plugin, serviceSupplier, oreConfigFactory).openSync(inventoryClickEvent.getWhoClicked());
        });
        this.addItem(biomeGuiSettings.getAbortSlot(), MessageUtil.replaceItemStack(plugin, biomeGuiSettings.getAbortItemStack(), new MessageValue[0]), inventoryClickEvent -> this.closeSync(inventoryClickEvent.getWhoClicked()));
        this.addItem(biomeGuiSettings.getNextSlot(), MessageUtil.replaceItemStack(plugin, biomeGuiSettings.getNextItemStack(), new MessageValue[0]), inventoryClickEvent -> consumer.accept(oreConfigFactory));
    }

    private static BiomeGuiSettings checkSettings(@NotNull Plugin plugin) {
        if (biomeGuiSettings == null) {
            biomeGuiSettings = new BiomeGuiSettings(plugin, "data/factory/gui/biome-gui.yml", true);
        }
        return biomeGuiSettings;
    }

    private ItemStack getItemStack(@NotNull Biome biome) {
        ItemStack itemStack = this.oreConfigFactory.getOreConfigBuilder().containsBiome(biome) ? biomeGuiSettings.getActivatedItemStack() : biomeGuiSettings.getDeactivatedItemStack();
        itemStack.setType(biomeGuiSettings.getBiomeMaterial(biome.toString()));
        return MessageUtil.replaceItemStack(this.getPlugin(), itemStack, new MessageValue("name", biome));
    }

    private void handleNormalClick(@NotNull Biome biome, @NotNull InventoryClickEvent event) {
        if (event.getClick() != ClickType.LEFT) {
            return;
        }
        OreConfigBuilder oreConfigBuilder = this.oreConfigFactory.getOreConfigBuilder();
        if (oreConfigBuilder.containsBiome(biome)) {
            oreConfigBuilder.removeBiome(biome);
        } else {
            oreConfigBuilder.addBiome(biome);
        }
        this.updateItemStack(biome, this.getItemStack(biome));
    }
}

