/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.factory.OreConfigBuilder;
import de.derfrzocker.custom.ore.generator.factory.gui.BiomeGui;
import de.derfrzocker.custom.ore.generator.factory.gui.BlockSelectorGui;
import de.derfrzocker.custom.ore.generator.factory.gui.CustomDatasGui;
import de.derfrzocker.custom.ore.generator.factory.gui.MenuGui;
import de.derfrzocker.custom.ore.generator.factory.gui.OreGeneratorGui;
import de.derfrzocker.custom.ore.generator.factory.gui.OreSettingsGui;
import de.derfrzocker.custom.ore.generator.factory.gui.WorldGui;
import de.derfrzocker.custom.ore.generator.factory.listeners.CommandListener;
import de.derfrzocker.custom.ore.generator.factory.listeners.MainMaterialListener;
import de.derfrzocker.custom.ore.generator.factory.listeners.ReplaceMaterialListener;
import de.derfrzocker.custom.ore.generator.factory.listeners.SelectMaterialListener;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ExactMatchConversationCanceller;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.RegexPrompt;
import org.bukkit.conversations.ValidatingPrompt;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreConfigFactory
implements Listener {
    private static final Pattern ORE_CONFIG_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]*$");
    @NotNull
    private final JavaPlugin javaPlugin;
    @NotNull
    private final Player player;
    @NotNull
    private final OreConfigBuilder oreConfigBuilder;
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    private boolean running = false;

    public OreConfigFactory(@NotNull JavaPlugin javaPlugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull Player player) {
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull(serviceSupplier, (String)"Service Supplier can not be null");
        Validate.notNull((Object)player, (String)"Player can not be null");
        this.javaPlugin = javaPlugin;
        this.serviceSupplier = serviceSupplier;
        this.player = player;
        this.oreConfigBuilder = OreConfigBuilder.newBuilder();
    }

    @NotNull
    public OreConfigBuilder getOreConfigBuilder() {
        return this.oreConfigBuilder;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean setName(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        Conversation conversation = new ConversationFactory((Plugin)this.javaPlugin).withModality(false).withEscapeSequence("!exit").withEscapeSequence("!menu").withLocalEcho(false).addConversationAbandonedListener(event -> {
            this.running = false;
            if (event.gracefulExit()) {
                consumer.accept(this);
                return;
            }
            ConversationCanceller canceller = event.getCanceller();
            if (canceller instanceof ExactMatchConversationCanceller && canceller.cancelBasedOnInput(null, "!menu")) {
                new MenuGui((Plugin)this.javaPlugin, this.serviceSupplier, this).openSync((HumanEntity)this.player);
            }
        }).withFirstPrompt((Prompt)new RegexPrompt(ORE_CONFIG_NAME_PATTERN){

            protected boolean isInputValid(@NotNull ConversationContext context, @NotNull String input) {
                if (super.isInputValid(context, input)) {
                    CustomOreGeneratorService service = (CustomOreGeneratorService)OreConfigFactory.this.serviceSupplier.get();
                    if (service.getOreConfig(input).isPresent()) {
                        new MessageKey((Plugin)OreConfigFactory.this.javaPlugin, "ore-config.factory.name.already-exists").sendMessage((CommandSender)OreConfigFactory.this.player, new MessageValue("ore-config", input));
                        return false;
                    }
                    return true;
                }
                return false;
            }

            @Nullable
            protected Prompt acceptValidatedInput(@NotNull ConversationContext conversationContext, @NotNull String name) {
                OreConfigFactory.this.oreConfigBuilder.name(name);
                OreConfigFactory.this.running = false;
                new MessageKey((Plugin)OreConfigFactory.this.javaPlugin, "ore-config.factory.name.success").sendMessage((CommandSender)OreConfigFactory.this.getPlayer(), new MessageValue("value", name));
                return END_OF_CONVERSATION;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext conversationContext) {
                return new MessageKey((Plugin)OreConfigFactory.this.javaPlugin, "ore-config.factory.name.text").getMessage(new MessageValue[0]);
            }

            @Nullable
            protected String getFailedValidationText(@NotNull ConversationContext context, @NotNull String invalidInput) {
                return new MessageKey((Plugin)OreConfigFactory.this.javaPlugin, "ore-config.factory.name.invalid").getMessage(new MessageValue("value", invalidInput));
            }
        }).buildConversation((Conversable)this.player);
        this.player.beginConversation(conversation);
        new CommandListener((Plugin)this.javaPlugin, this.player, conversation);
        return true;
    }

    public boolean setMaterial(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        Conversation conversation = new ConversationFactory((Plugin)this.javaPlugin).withModality(false).withEscapeSequence("!exit").withEscapeSequence("!menu").withLocalEcho(false).addConversationAbandonedListener(event -> {
            this.running = false;
            if (event.gracefulExit()) {
                consumer.accept(this);
                return;
            }
            ConversationCanceller canceller = event.getCanceller();
            if (canceller instanceof ExactMatchConversationCanceller && canceller.cancelBasedOnInput(null, "!menu")) {
                new MenuGui((Plugin)this.javaPlugin, this.serviceSupplier, this).openSync((HumanEntity)this.player);
            }
        }).withFirstPrompt((Prompt)new ValidatingPrompt(){

            protected boolean isInputValid(@NotNull ConversationContext conversationContext, @NotNull String text) {
                return text.equals("!next");
            }

            @Nullable
            protected Prompt acceptValidatedInput(@NotNull ConversationContext conversationContext, @NotNull String name) {
                OreConfigFactory.this.running = false;
                return END_OF_CONVERSATION;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext conversationContext) {
                return new MessageKey((Plugin)OreConfigFactory.this.javaPlugin, "ore-config.factory.material.text").getMessage(new MessageValue[0]);
            }
        }).buildConversation((Conversable)this.player);
        this.player.beginConversation(conversation);
        new MainMaterialListener(this.javaPlugin, this.serviceSupplier, this.player, this.oreConfigBuilder, conversation);
        new CommandListener((Plugin)this.javaPlugin, this.player, conversation);
        return true;
    }

    public boolean setReplaceMaterials(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        Conversation conversation = new ConversationFactory((Plugin)this.javaPlugin).withModality(false).withEscapeSequence("!exit").withEscapeSequence("!menu").withLocalEcho(false).addConversationAbandonedListener(event -> {
            this.running = false;
            if (event.gracefulExit()) {
                consumer.accept(this);
                return;
            }
            ConversationCanceller canceller = event.getCanceller();
            if (canceller instanceof ExactMatchConversationCanceller && canceller.cancelBasedOnInput(null, "!menu")) {
                new MenuGui((Plugin)this.javaPlugin, this.serviceSupplier, this).openSync((HumanEntity)this.player);
            }
        }).withFirstPrompt((Prompt)new ValidatingPrompt(){

            protected boolean isInputValid(@NotNull ConversationContext conversationContext, @NotNull String text) {
                return text.equals("!next");
            }

            @Nullable
            protected Prompt acceptValidatedInput(@NotNull ConversationContext conversationContext, @NotNull String name) {
                OreConfigFactory.this.running = false;
                return END_OF_CONVERSATION;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext conversationContext) {
                return new MessageKey((Plugin)OreConfigFactory.this.javaPlugin, "ore-config.factory.replace-material.text").getMessage(new MessageValue[0]);
            }
        }).buildConversation((Conversable)this.player);
        this.player.beginConversation(conversation);
        new ReplaceMaterialListener(this.javaPlugin, this.serviceSupplier, this.player, this.oreConfigBuilder, conversation);
        new CommandListener((Plugin)this.javaPlugin, this.player, conversation);
        return true;
    }

    public boolean setSelectMaterials(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        Conversation conversation = new ConversationFactory((Plugin)this.javaPlugin).withModality(false).withEscapeSequence("!exit").withEscapeSequence("!menu").withLocalEcho(false).addConversationAbandonedListener(event -> {
            this.running = false;
            if (event.gracefulExit()) {
                consumer.accept(this);
                return;
            }
            ConversationCanceller canceller = event.getCanceller();
            if (canceller instanceof ExactMatchConversationCanceller && canceller.cancelBasedOnInput(null, "!menu")) {
                new MenuGui((Plugin)this.javaPlugin, this.serviceSupplier, this).openSync((HumanEntity)this.player);
            }
        }).withFirstPrompt((Prompt)new ValidatingPrompt(){

            protected boolean isInputValid(@NotNull ConversationContext conversationContext, @NotNull String text) {
                return text.equals("!next");
            }

            @Nullable
            protected Prompt acceptValidatedInput(@NotNull ConversationContext conversationContext, @NotNull String name) {
                OreConfigFactory.this.running = false;
                return END_OF_CONVERSATION;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext conversationContext) {
                return new MessageKey((Plugin)OreConfigFactory.this.javaPlugin, "ore-config.factory.select-material.text").getMessage(new MessageValue[0]);
            }
        }).buildConversation((Conversable)this.player);
        this.player.beginConversation(conversation);
        new SelectMaterialListener(this.javaPlugin, this.serviceSupplier, this.player, this.oreConfigBuilder, conversation);
        new CommandListener((Plugin)this.javaPlugin, this.player, conversation);
        return true;
    }

    public boolean setOreGenerator(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        new OreGeneratorGui((Plugin)this.javaPlugin, this.serviceSupplier, this, oreConfigFactory -> {
            this.running = false;
            consumer.accept((OreConfigFactory)oreConfigFactory);
        }).openSync((HumanEntity)this.player);
        return true;
    }

    public boolean setBlockSelector(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        new BlockSelectorGui((Plugin)this.javaPlugin, this.serviceSupplier, this, oreConfigFactory -> {
            this.running = false;
            consumer.accept((OreConfigFactory)oreConfigFactory);
        }).openSync((HumanEntity)this.player);
        return true;
    }

    public boolean setBiomes(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        new BiomeGui((Plugin)this.javaPlugin, this.serviceSupplier, this, oreConfigFactory -> {
            this.running = false;
            consumer.accept((OreConfigFactory)oreConfigFactory);
        }).openSync((HumanEntity)this.player);
        return true;
    }

    public boolean setOreGeneratorOreSettings(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        new OreSettingsGui((Plugin)this.javaPlugin, this.serviceSupplier, this, oreConfigFactory -> {
            this.running = false;
            consumer.accept((OreConfigFactory)oreConfigFactory);
        }, this.oreConfigBuilder.oreGenerator(), this.oreConfigBuilder.getOreGeneratorOreSettings()).openSync((HumanEntity)this.player);
        return true;
    }

    public boolean setBlockSelectorOreSettings(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        new OreSettingsGui((Plugin)this.javaPlugin, this.serviceSupplier, this, oreConfigFactory -> {
            this.running = false;
            consumer.accept((OreConfigFactory)oreConfigFactory);
        }, this.oreConfigBuilder.blockSelector(), this.oreConfigBuilder.getBlockSelectorOreSettings()).openSync((HumanEntity)this.player);
        return true;
    }

    public boolean setCustomDatas(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        new CustomDatasGui((Plugin)this.javaPlugin, this.serviceSupplier, this, oreConfigFactory -> {
            this.running = false;
            consumer.accept((OreConfigFactory)oreConfigFactory);
        }).openSync((HumanEntity)this.player);
        return true;
    }

    public boolean setWorlds(@NotNull Consumer<OreConfigFactory> consumer) {
        if (this.running) {
            return false;
        }
        this.running = true;
        new WorldGui((Plugin)this.javaPlugin, this.serviceSupplier, this, oreConfigFactory -> {
            this.running = false;
            consumer.accept((OreConfigFactory)oreConfigFactory);
        }).openSync((HumanEntity)this.player);
        return true;
    }

    public boolean setName() {
        return this.setName(OreConfigFactory::setMaterial);
    }

    public boolean setMaterial() {
        return this.setMaterial(OreConfigFactory::setReplaceMaterials);
    }

    public boolean setReplaceMaterials() {
        return this.setReplaceMaterials(OreConfigFactory::setSelectMaterials);
    }

    public boolean setSelectMaterials() {
        return this.setSelectMaterials(OreConfigFactory::setOreGenerator);
    }

    public boolean setOreGenerator() {
        return this.setOreGenerator(OreConfigFactory::setBlockSelector);
    }

    public boolean setBlockSelector() {
        return this.setBlockSelector(OreConfigFactory::setBiomes);
    }

    public boolean setBiomes() {
        return this.setBiomes(factory -> {
            OreConfigBuilder oreConfigBuilder = factory.getOreConfigBuilder();
            OreGenerator oreGenerator = oreConfigBuilder.oreGenerator();
            if (oreGenerator != null && !oreGenerator.getNeededOreSettings().isEmpty()) {
                this.setOreGeneratorOreSettings();
                return;
            }
            BlockSelector blockSelector = oreConfigBuilder.blockSelector();
            if (blockSelector != null && !blockSelector.getNeededOreSettings().isEmpty()) {
                this.setBlockSelectorOreSettings();
                return;
            }
            this.checkCustomDatas(oreConfigBuilder);
        });
    }

    public boolean setOreGeneratorOreSettings() {
        return this.setOreGeneratorOreSettings(factory -> {
            OreConfigBuilder oreConfigBuilder = factory.getOreConfigBuilder();
            BlockSelector blockSelector = oreConfigBuilder.blockSelector();
            if (blockSelector != null && !blockSelector.getNeededOreSettings().isEmpty()) {
                this.setBlockSelectorOreSettings();
                return;
            }
            this.checkCustomDatas(oreConfigBuilder);
        });
    }

    public boolean setBlockSelectorOreSettings() {
        return this.setBlockSelectorOreSettings(factory -> this.checkCustomDatas(factory.getOreConfigBuilder()));
    }

    public boolean setCustomDatas() {
        return this.setCustomDatas(OreConfigFactory::setWorlds);
    }

    public boolean setWorlds() {
        return this.setWorlds(factory -> new MenuGui((Plugin)this.javaPlugin, this.serviceSupplier, (OreConfigFactory)factory).openSync((HumanEntity)factory.getPlayer()));
    }

    private void checkCustomDatas(OreConfigBuilder oreConfigBuilder) {
        if (oreConfigBuilder.foundCustomDatas().isEmpty()) {
            this.setWorlds();
            return;
        }
        if (oreConfigBuilder.name() == null) {
            this.setWorlds();
            return;
        }
        if (oreConfigBuilder.material() == null) {
            this.setWorlds();
            return;
        }
        if (oreConfigBuilder.replaceMaterial().isEmpty()) {
            this.setWorlds();
            return;
        }
        if (oreConfigBuilder.oreGenerator() == null) {
            this.setWorlds();
            return;
        }
        if (oreConfigBuilder.blockSelector() == null) {
            this.setWorlds();
            return;
        }
        this.setCustomDatas();
    }
}

