/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.factory;

import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.OreSettingContainer;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreConfigBuilder {
    @NotNull
    private final Set<Material> replaceMaterial = new LinkedHashSet<Material>();
    @NotNull
    private final Set<Material> selectMaterial = new LinkedHashSet<Material>();
    @NotNull
    private final OreSettingContainer oreGeneratorOreSettings = new SimpleOreSettingsContainer();
    @NotNull
    private final OreSettingContainer blockSelectorOreSettings = new SimpleOreSettingsContainer();
    @NotNull
    private final Map<CustomData, Object> customDatas = new LinkedHashMap<CustomData, Object>();
    @NotNull
    private final Set<Biome> biomes = new LinkedHashSet<Biome>();
    @NotNull
    private final Set<World> worlds = new LinkedHashSet<World>();
    @NotNull
    private final Map<CustomData, Object> foundCustomData = new LinkedHashMap<CustomData, Object>();
    @Nullable
    private String name;
    @Nullable
    private Material material;
    @Nullable
    private OreGenerator oreGenerator;
    @Nullable
    private BlockSelector blockSelector;

    public static OreConfigBuilder newBuilder() {
        return new OreConfigBuilder();
    }

    @NotNull
    public OreConfigBuilder name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @NotNull
    public OreConfigBuilder material(@Nullable Material material) {
        this.material = material;
        return this;
    }

    @Nullable
    public Material material() {
        return this.material;
    }

    @NotNull
    public OreConfigBuilder addReplaceMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.replaceMaterial.add(material);
        return this;
    }

    @NotNull
    public OreConfigBuilder removeReplaceMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.replaceMaterial.remove(material);
        return this;
    }

    public boolean containsReplaceMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        return this.replaceMaterial.contains(material);
    }

    @NotNull
    public Set<Material> replaceMaterial() {
        return this.replaceMaterial;
    }

    @NotNull
    public OreConfigBuilder addSelectMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.selectMaterial.add(material);
        return this;
    }

    @NotNull
    public OreConfigBuilder removeSelectMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        this.selectMaterial.remove(material);
        return this;
    }

    public boolean containsSelectMaterial(@NotNull Material material) {
        Validate.notNull((Object)material, (String)"Material can not be null");
        return this.selectMaterial.contains(material);
    }

    @NotNull
    public Set<Material> selectMaterial() {
        return this.selectMaterial;
    }

    @Nullable
    public OreGenerator oreGenerator() {
        return this.oreGenerator;
    }

    @NotNull
    public OreConfigBuilder oreGenerator(@Nullable OreGenerator oreGenerator) {
        this.oreGenerator = oreGenerator;
        return this;
    }

    @Nullable
    public BlockSelector blockSelector() {
        return this.blockSelector;
    }

    @NotNull
    public OreConfigBuilder blockSelector(@Nullable BlockSelector blockSelector) {
        this.blockSelector = blockSelector;
        return this;
    }

    @NotNull
    public OreSettingContainer getOreGeneratorOreSettings() {
        return this.oreGeneratorOreSettings;
    }

    @NotNull
    public OreSettingContainer getBlockSelectorOreSettings() {
        return this.blockSelectorOreSettings;
    }

    @NotNull
    public OreConfigBuilder setCustomData(@NotNull CustomData customData, @NotNull Object value) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        Validate.notNull((Object)value, (String)"CustomData value can not be null");
        this.customDatas.put(customData, value);
        return this;
    }

    @Nullable
    public Object getCustomData(@NotNull CustomData customData) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        return this.customDatas.get(customData);
    }

    @Nullable
    public OreConfigBuilder removeCustomData(@NotNull CustomData customData) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        this.customDatas.remove(customData);
        return this;
    }

    @NotNull
    public Map<CustomData, Object> customDatas() {
        return this.customDatas;
    }

    @NotNull
    public OreConfigBuilder addBiome(@NotNull Biome biome) {
        Validate.notNull((Object)biome, (String)"Biome can not be null");
        this.biomes.add(biome);
        return this;
    }

    @NotNull
    public OreConfigBuilder removeBiome(@NotNull Biome biome) {
        Validate.notNull((Object)biome, (String)"Biome can not be null");
        this.biomes.remove(biome);
        return this;
    }

    public boolean containsBiome(@NotNull Biome biome) {
        Validate.notNull((Object)biome, (String)"Biome can not be null");
        return this.biomes.contains(biome);
    }

    @NotNull
    public Set<Biome> biomes() {
        return this.biomes;
    }

    @NotNull
    public OreConfigBuilder addWorld(@NotNull World world) {
        Validate.notNull((Object)world, (String)"World can not be null");
        this.worlds.add(world);
        return this;
    }

    @NotNull
    public OreConfigBuilder removeWorld(@NotNull World world) {
        Validate.notNull((Object)world, (String)"World can not be null");
        this.worlds.remove(world);
        return this;
    }

    public boolean containsWorld(@NotNull World world) {
        Validate.notNull((Object)world, (String)"World can not be null");
        return this.worlds.contains(world);
    }

    @NotNull
    public Set<World> worlds() {
        return this.worlds;
    }

    @NotNull
    public OreConfigBuilder setFoundCustomData(@NotNull CustomData customData, @NotNull Object value) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        Validate.notNull((Object)value, (String)"CustomData value can not be null");
        this.foundCustomData.put(customData, value);
        return this;
    }

    @Nullable
    public Object getFoundCustomData(@NotNull CustomData customData) {
        Validate.notNull((Object)customData, (String)"CustomData can not be null");
        return this.foundCustomData.get(customData);
    }

    @NotNull
    public Map<CustomData, Object> foundCustomDatas() {
        return this.foundCustomData;
    }

    private final class SimpleOreSettingsContainer
    implements OreSettingContainer {
        private final Map<OreSetting, Double> oreSettings = new LinkedHashMap<OreSetting, Double>();

        private SimpleOreSettingsContainer() {
        }

        @Override
        public void setValue(@NotNull OreSetting oreSetting, double value) {
            Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
            this.oreSettings.put(oreSetting, value);
        }

        @Override
        @NotNull
        public Optional<Double> getValue(@NotNull OreSetting oreSetting) {
            Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
            return Optional.ofNullable(this.oreSettings.get(oreSetting));
        }

        @Override
        public boolean removeValue(@NotNull OreSetting oreSetting) {
            Validate.notNull((Object)oreSetting, (String)"OreSetting can not be null");
            return this.oreSettings.remove(oreSetting) != null;
        }

        @Override
        @NotNull
        public Map<OreSetting, Double> getValues() {
            return new LinkedHashMap<OreSetting, Double>(this.oreSettings);
        }
    }
}

