/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command.set.value;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.command.OreGenCommand;
import de.derfrzocker.custom.ore.generator.utils.command.CommandUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SetValueOreGeneratorCommand
implements TabExecutor {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final JavaPlugin javaPlugin;
    @NotNull
    private final CustomOreGeneratorMessages messages;

    public SetValueOreGeneratorCommand(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        this.serviceSupplier = serviceSupplier;
        this.javaPlugin = javaPlugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length != 3) {
            this.messages.COMMAND_SET_VALUE_ORE_GENERATOR_NOT_ENOUGH_ARGS.sendMessage(sender, new MessageValue[0]);
            return true;
        }
        CommandUtil.runAsynchronously(sender, (Plugin)this.javaPlugin, () -> {
            double value2;
            String configName = args[0];
            String settingName = args[1];
            String amount = args[2];
            CustomOreGeneratorService service = this.serviceSupplier.get();
            OreConfig oreConfig = OreGenCommand.getOreConfig(configName, service, this.messages.COMMAND_ORE_CONFIG_NOT_FOUND, sender);
            OreSetting setting = OreSetting.getOreSetting(settingName.toUpperCase());
            if (setting == null) {
                this.messages.COMMAND_SET_VALUE_ORE_GENERATOR_SETTING_NOT_FOUND.sendMessage(sender, new MessageValue("setting", settingName));
                return;
            }
            Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(oreConfig.getOreGenerator());
            if (!optionalOreGenerator.isPresent()) {
                this.messages.COMMAND_ORE_GENERATOR_NOT_FOUND.sendMessage(sender, new MessageValue("ore-generator", oreConfig.getOreGenerator()));
                return;
            }
            OreGenerator generator = optionalOreGenerator.get();
            if (generator.getNeededOreSettings().stream().noneMatch(value -> value == setting)) {
                this.messages.COMMAND_SET_VALUE_ORE_GENERATOR_SETTING_NOT_VALID.sendMessage(sender, new MessageValue("setting", settingName), new MessageValue("ore-generator", generator.getName()));
                return;
            }
            try {
                value2 = Double.parseDouble(amount);
            }
            catch (NumberFormatException e) {
                this.messages.COMMAND_SET_VALUE_ORE_GENERATOR_VALUE_NOT_VALID.sendMessage(sender, new MessageValue("value", amount));
                return;
            }
            oreConfig.getOreGeneratorOreSettings().setValue(setting, value2);
            service.saveOreConfig(oreConfig);
            this.messages.COMMAND_SET_VALUE_ORE_GENERATOR_SUCCESS.sendMessage(sender, new MessageValue("value", value2));
        });
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        CustomOreGeneratorService service = this.serviceSupplier.get();
        if (args.length == 1) {
            String configName = args[0];
            service.getOreConfigs().stream().map(OreConfig::getName).filter(name -> name.contains(configName)).forEach(list::add);
            return list;
        }
        if (args.length == 2) {
            Optional<OreConfig> oreConfig = service.getOreConfig(args[0]);
            if (!oreConfig.isPresent()) {
                return list;
            }
            String settingName = args[1].toUpperCase();
            Optional<OreGenerator> oreGenerator = service.getOreGenerator(oreConfig.get().getOreGenerator());
            oreGenerator.ifPresent(generator -> generator.getNeededOreSettings().stream().map(OreSetting::getName).filter(value -> value.contains(settingName)).forEach(list::add));
            return list;
        }
        return list;
    }
}

