/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command.set;

import com.google.common.collect.Sets;
import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.command.OreGenCommand;
import de.derfrzocker.custom.ore.generator.utils.command.CommandUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetReplaceMaterialCommand
implements TabExecutor {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final JavaPlugin javaPlugin;
    @NotNull
    private final CustomOreGeneratorMessages messages;

    public SetReplaceMaterialCommand(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        this.serviceSupplier = serviceSupplier;
        this.javaPlugin = javaPlugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 2) {
            this.messages.COMMAND_SET_REPLACE_MATERIAL_NOT_ENOUGH_ARGS.sendMessage(sender, new MessageValue[0]);
            return true;
        }
        CommandUtil.runAsynchronously(sender, (Plugin)this.javaPlugin, () -> {
            String configName = args[0];
            CustomOreGeneratorService service = this.serviceSupplier.get();
            OreConfig oreConfig = OreGenCommand.getOreConfig(configName, service, this.messages.COMMAND_ORE_CONFIG_NOT_FOUND, sender);
            HashSet<Material> materials = new HashSet<Material>();
            for (int i = 1; i < args.length; ++i) {
                try {
                    Material material = Material.valueOf((String)args[i].toUpperCase());
                    if (!material.isBlock()) {
                        this.messages.COMMAND_MATERIAL_NO_BLOCK.sendMessage(sender, new MessageValue("material", args[i]));
                        return;
                    }
                    materials.add(material);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.messages.COMMAND_MATERIAL_NOT_FOUND.sendMessage(sender, new MessageValue("material", args[i]));
                    return;
                }
            }
            oreConfig.getReplaceMaterials().forEach(oreConfig::removeReplaceMaterial);
            materials.forEach(oreConfig::addReplaceMaterial);
            service.saveOreConfig(oreConfig);
            this.messages.COMMAND_SET_REPLACE_MATERIAL_SUCCESS.sendMessage(sender, new MessageValue[0]);
        });
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        CustomOreGeneratorService service = this.serviceSupplier.get();
        if (args.length == 1) {
            String configName = args[0];
            service.getOreConfigs().stream().map(OreConfig::getName).filter(name -> name.contains(configName)).forEach(list::add);
            return list;
        }
        Optional<OreConfig> oreConfig = service.getOreConfig(args[0]);
        if (!oreConfig.isPresent()) {
            return list;
        }
        HashSet<Material> materials = new HashSet<Material>();
        for (int i = 1; i < args.length - 1; ++i) {
            try {
                Material material = Material.valueOf((String)args[i].toUpperCase());
                if (!material.isBlock()) {
                    return list;
                }
                materials.add(material);
                continue;
            }
            catch (IllegalArgumentException e) {
                return list;
            }
        }
        HashSet materialSet = Sets.newHashSet((Object[])Material.values());
        materialSet.removeAll(materials);
        materialSet.stream().filter(Material::isBlock).map(Enum::toString).filter(value -> value.contains(args[args.length - 1])).forEach(list::add);
        return list;
    }
}

