/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command.set;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomDataType;
import de.derfrzocker.custom.ore.generator.command.OreGenCommand;
import de.derfrzocker.custom.ore.generator.utils.command.CommandUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SetCustomDataCommand
implements TabExecutor {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final JavaPlugin javaPlugin;
    @NotNull
    private final CustomOreGeneratorMessages messages;

    public SetCustomDataCommand(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        this.serviceSupplier = serviceSupplier;
        this.javaPlugin = javaPlugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 3) {
            this.messages.COMMAND_SET_CUSTOMDATA_NOT_ENOUGH_ARGS.sendMessage(sender, new MessageValue[0]);
            return true;
        }
        CommandUtil.runAsynchronously(sender, (Plugin)this.javaPlugin, () -> {
            Object data;
            String configName = args[0];
            String customDataName = args[1];
            String customDataValue = this.buildStrings(args);
            CustomOreGeneratorService service = this.serviceSupplier.get();
            OreConfig oreConfig = OreGenCommand.getOreConfig(configName, service, this.messages.COMMAND_ORE_CONFIG_NOT_FOUND, sender);
            Optional<CustomData> customDataOptional = service.getCustomData(customDataName);
            if (!customDataOptional.isPresent()) {
                this.messages.COMMAND_SET_CUSTOMDATA_NOT_FOUND.sendMessage(sender, new MessageValue("customdata", customDataName));
                return;
            }
            CustomData customData = customDataOptional.get();
            if (!customData.canApply(oreConfig)) {
                this.messages.COMMAND_SET_CUSTOMDATA_ORE_CONFIG_NOT_VALID.sendMessage(sender, new MessageValue("customdata", customData.getName()), new MessageValue("ore-config", oreConfig.getName()));
                return;
            }
            try {
                data = this.parse(customDataValue, customData.getCustomDataType());
            }
            catch (IllegalArgumentException e) {
                this.messages.COMMAND_SET_CUSTOMDATA_VALUE_NOT_VALID.sendMessage(sender, new MessageValue("value", customDataValue));
                return;
            }
            if (!customData.isValidCustomData(data, oreConfig)) {
                this.messages.COMMAND_SET_CUSTOMDATA_VALUE_NOT_VALID.sendMessage(sender, new MessageValue("value", data));
                return;
            }
            oreConfig.setCustomData(customData, customData.normalize(data, oreConfig));
            service.saveOreConfig(oreConfig);
            this.messages.COMMAND_SET_CUSTOMDATA_SUCCESS.sendMessage(sender, new MessageValue[0]);
        });
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        CustomOreGeneratorService service = this.serviceSupplier.get();
        if (args.length == 1) {
            String configName = args[0];
            service.getOreConfigs().stream().map(OreConfig::getName).filter(name -> name.contains(configName)).forEach(list::add);
            return list;
        }
        if (args.length == 2) {
            Optional<OreConfig> oreConfig = service.getOreConfig(args[0]);
            if (!oreConfig.isPresent()) {
                return list;
            }
            String customDataName = args[1].toUpperCase();
            service.getCustomData().stream().filter(customData -> customData.canApply((OreConfig)oreConfig.get())).map(CustomData::getName).filter(value -> value.contains(customDataName)).forEach(list::add);
            return list;
        }
        return list;
    }

    private Object parse(String data, CustomDataType customDataType) throws IllegalArgumentException {
        switch (customDataType) {
            case STRING: {
                return data;
            }
            case INTEGER: {
                return Integer.parseInt(data);
            }
            case DOUBLE: {
                return Double.parseDouble(data);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(data);
            }
        }
        throw new IllegalArgumentException();
    }

    private String buildStrings(String[] args) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 2; i < args.length; ++i) {
            if (i != 2) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(args[i]);
        }
        return stringBuilder.toString();
    }
}

