/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command.set;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.Permissions;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.command.HelpConfigImpl;
import de.derfrzocker.custom.ore.generator.command.set.SetBiomeCommand;
import de.derfrzocker.custom.ore.generator.command.set.SetCustomDataCommand;
import de.derfrzocker.custom.ore.generator.command.set.SetPositionCommand;
import de.derfrzocker.custom.ore.generator.command.set.SetReplaceMaterialCommand;
import de.derfrzocker.custom.ore.generator.command.set.SetSelectMaterialCommand;
import de.derfrzocker.custom.ore.generator.command.set.value.SetValueCommand;
import de.derfrzocker.custom.ore.generator.utils.command.CommandSeparator;
import de.derfrzocker.custom.ore.generator.utils.command.HelpCommand;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SetCommand
extends CommandSeparator {
    public SetCommand(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages, @NotNull Permissions permissions) {
        super((Plugin)javaPlugin);
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        Validate.notNull((Object)permissions, (String)"Permissions can not be null");
        this.registerExecutor(new SetValueCommand(serviceSupplier, javaPlugin, messages, permissions), "value", permissions.SET_VALUE_PERMISSION, messages.COMMAND_SET_VALUE_USAGE, messages.COMMAND_SET_VALUE_DESCRIPTION);
        this.registerExecutor(new SetBiomeCommand(serviceSupplier, javaPlugin, messages), "biome", permissions.SET_BIOME_PERMISSION, messages.COMMAND_SET_BIOME_USAGE, messages.COMMAND_SET_BIOME_DESCRIPTION);
        this.registerExecutor(new SetCustomDataCommand(serviceSupplier, javaPlugin, messages), "customdata", permissions.SET_CUSTOMDATA_PERMISSION, messages.COMMAND_SET_CUSTOMDATA_USAGE, messages.COMMAND_SET_CUSTOMDATA_DESCRIPTION);
        this.registerExecutor(new SetReplaceMaterialCommand(serviceSupplier, javaPlugin, messages), "replace-material", permissions.SET_REPLACE_MATERIAL_PERMISSION, messages.COMMAND_SET_REPLACE_MATERIAL_USAGE, messages.COMMAND_SET_REPLACE_MATERIAL_DESCRIPTION);
        this.registerExecutor(new SetSelectMaterialCommand(serviceSupplier, javaPlugin, messages), "select-material", permissions.SET_SELECT_MATERIAL_PERMISSION, messages.COMMAND_SET_SELECT_MATERIAL_USAGE, messages.COMMAND_SET_SELECT_MATERIAL_DESCRIPTION);
        this.registerExecutor(new SetPositionCommand(serviceSupplier, javaPlugin, messages), "position", permissions.SET_POSITION_PERMISSION, messages.COMMAND_SET_POSITION_USAGE, messages.COMMAND_SET_POSITION_DESCRIPTION);
        HelpCommand helpCommand = new HelpCommand(this, new HelpConfigImpl(messages));
        this.registerExecutor(helpCommand, "help", null, messages.COMMAND_SET_HELP_USAGE, messages.COMMAND_HELP_DESCRIPTION);
        this.registerExecutor(helpCommand, null, null, messages.COMMAND_SET_HELP_USAGE, messages.COMMAND_HELP_DESCRIPTION);
    }
}

