/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command.add;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.utils.command.CommandUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddOreConfigCommand
implements TabExecutor {
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final JavaPlugin javaPlugin;
    @NotNull
    private final CustomOreGeneratorMessages messages;

    public AddOreConfigCommand(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        this.serviceSupplier = serviceSupplier;
        this.javaPlugin = javaPlugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 2 || args.length > 3) {
            this.messages.COMMAND_ADD_ORE_CONFIG_NOT_ENOUGH_ARGS.sendMessage(sender, new MessageValue[0]);
            return true;
        }
        CommandUtil.runAsynchronously(sender, (Plugin)this.javaPlugin, () -> {
            WorldConfig worldConfig;
            String worldName = args[0];
            String configName = args[1];
            String positionString = args.length == 3 ? args[2] : null;
            CustomOreGeneratorService service = this.serviceSupplier.get();
            Optional<WorldConfig> worldConfigOptional = service.getWorldConfig(worldName);
            if (worldConfigOptional.isPresent()) {
                worldConfig = worldConfigOptional.get();
            } else {
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    this.messages.COMMAND_WORLD_NOT_FOUND.sendMessage(sender, new MessageValue("world", worldName));
                    return;
                }
                worldConfig = service.createWorldConfig(world);
            }
            if (worldConfig.getOreConfig(configName).isPresent()) {
                this.messages.COMMAND_ADD_ORE_CONFIG_PRESENT.sendMessage(sender, new MessageValue("ore-config", configName));
                return;
            }
            Optional<OreConfig> oreConfigOptional = service.getOreConfig(configName);
            if (!oreConfigOptional.isPresent()) {
                this.messages.COMMAND_ORE_CONFIG_NOT_FOUND.sendMessage(sender, new MessageValue("ore-config", configName));
                return;
            }
            OreConfig oreConfig = oreConfigOptional.get();
            if (positionString != null) {
                int position;
                try {
                    position = Integer.parseInt(positionString);
                }
                catch (NumberFormatException e) {
                    this.messages.COMMAND_ADD_ORE_CONFIG_VALUE_NOT_VALID.sendMessage(sender, new MessageValue("value", positionString));
                    return;
                }
                worldConfig.addOreConfig(oreConfig, position);
            } else {
                worldConfig.addOreConfig(oreConfig);
            }
            service.saveWorldConfig(worldConfig);
            this.messages.COMMAND_ADD_ORE_CONFIG_SUCCESS.sendMessage(sender, new MessageValue[0]);
        });
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        CustomOreGeneratorService service = this.serviceSupplier.get();
        if (args.length == 1) {
            String worldName = args[0].toLowerCase();
            Bukkit.getWorlds().stream().map(WorldInfo::getName).filter(value -> value.toLowerCase().contains(worldName)).forEach(list::add);
            return list;
        }
        if (args.length == 2) {
            Optional<World> world = Bukkit.getWorlds().stream().filter(value -> value.getName().equalsIgnoreCase(args[0])).findAny();
            if (!world.isPresent()) {
                return list;
            }
            Optional<WorldConfig> worldConfig = service.getWorldConfig(world.get().getName());
            HashSet<OreConfig> oreConfigs = new HashSet<OreConfig>(service.getOreConfigs());
            String configName = args[1];
            worldConfig.ifPresent(worldConfig1 -> oreConfigs.removeAll(worldConfig1.getOreConfigs()));
            oreConfigs.stream().map(OreConfig::getName).filter(name -> name.contains(configName)).forEach(list::add);
            return list;
        }
        return list;
    }
}

