/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.utils.ReloadAble;
import de.derfrzocker.custom.ore.generator.utils.command.CommandUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ReloadCommand
implements TabExecutor {
    @NotNull
    private final JavaPlugin javaPlugin;
    @NotNull
    private final CustomOreGeneratorMessages messages;

    public ReloadCommand(@NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages) {
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        this.javaPlugin = javaPlugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        CommandUtil.runAsynchronously(sender, (Plugin)this.javaPlugin, () -> {
            this.messages.COMMAND_RELOAD_BEGIN.sendMessage(sender, new MessageValue[0]);
            ReloadAble.RELOAD_ABLES.forEach(ReloadAble::reload);
            this.messages.COMMAND_RELOAD_END.sendMessage(sender, new MessageValue[0]);
        });
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }
}

