/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.Permissions;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.WorldConfig;
import de.derfrzocker.custom.ore.generator.command.CreateCommand;
import de.derfrzocker.custom.ore.generator.command.HelpConfigImpl;
import de.derfrzocker.custom.ore.generator.command.InfoCommand;
import de.derfrzocker.custom.ore.generator.command.ReloadCommand;
import de.derfrzocker.custom.ore.generator.command.add.AddCommand;
import de.derfrzocker.custom.ore.generator.command.set.SetCommand;
import de.derfrzocker.custom.ore.generator.utils.Pair;
import de.derfrzocker.custom.ore.generator.utils.command.CommandException;
import de.derfrzocker.custom.ore.generator.utils.command.CommandSeparator;
import de.derfrzocker.custom.ore.generator.utils.command.HelpCommand;
import de.derfrzocker.custom.ore.generator.utils.message.MessageKey;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OreGenCommand
extends CommandSeparator {
    public OreGenCommand(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages, @NotNull Permissions permissions) {
        super((Plugin)javaPlugin);
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        Validate.notNull((Object)permissions, (String)"Permissions can not be null");
        this.registerExecutor(new SetCommand(serviceSupplier, javaPlugin, messages, permissions), "set", permissions.SET_PERMISSION, messages.COMMAND_SET_USAGE, messages.COMMAND_SET_DESCRIPTION);
        this.registerExecutor(new AddCommand(serviceSupplier, javaPlugin, messages, permissions), "add", permissions.ADD_PERMISSION, messages.COMMAND_ADD_USAGE, messages.COMMAND_ADD_DESCRIPTION);
        this.registerExecutor(new ReloadCommand(javaPlugin, messages), "reload", permissions.RELOAD_PERMISSION, messages.COMMAND_RELOAD_USAGE, messages.COMMAND_RELOAD_DESCRIPTION);
        this.registerExecutor(new CreateCommand(serviceSupplier, javaPlugin, messages), "create", permissions.CREATE_PERMISSION, messages.COMMAND_CREATE_USAGE, messages.COMMAND_CREATE_DESCRIPTION);
        HelpCommand helpCommand = new HelpCommand(this, new HelpConfigImpl(messages));
        this.registerExecutor(helpCommand, "help", null, messages.COMMAND_HELP_USAGE, messages.COMMAND_HELP_DESCRIPTION);
        this.registerExecutor(helpCommand, null, null, messages.COMMAND_HELP_USAGE, messages.COMMAND_HELP_DESCRIPTION);
        this.registerExecutor(new InfoCommand((Plugin)javaPlugin), "info", null, messages.COMMAND_INFO_USAGE, messages.COMMAND_INFO_DESCRIPTION);
    }

    @NotNull
    public static Pair<WorldConfig, OreConfig> getWorldAndOreConfig(@NotNull World world, @NotNull String oreConfigName, @NotNull CustomOreGeneratorService service, @Nullable MessageKey messageKey, @Nullable CommandSender commandSender) {
        Validate.notNull((Object)world, (String)"World can not be null");
        Validate.notNull((Object)oreConfigName, (String)"OreConfig name can not be null");
        Validate.notNull((Object)service, (String)"CustomOreGeneratorService can not be null");
        Optional<WorldConfig> worldConfigOptional = service.getWorldConfig(world.getName());
        if (!worldConfigOptional.isPresent()) {
            if (messageKey != null && commandSender != null) {
                messageKey.sendMessage(commandSender, new MessageValue("world", world.getName()), new MessageValue("ore-config", oreConfigName));
            }
            throw new CommandException("WorldConfig for world " + world.getName() + " not found");
        }
        WorldConfig worldConfig = worldConfigOptional.get();
        Optional<OreConfig> oreConfigOptional = worldConfig.getOreConfig(oreConfigName);
        if (!oreConfigOptional.isPresent()) {
            if (messageKey != null && commandSender != null) {
                messageKey.sendMessage(commandSender, new MessageValue("world", world.getName()), new MessageValue("ore-config", oreConfigName));
            }
            throw new CommandException("OreConfig " + oreConfigName + " for world " + world.getName() + " not found");
        }
        return new Pair<WorldConfig, OreConfig>(worldConfig, oreConfigOptional.get());
    }

    @NotNull
    public static OreConfig getOreConfig(@NotNull String oreConfigName, @NotNull CustomOreGeneratorService service, @Nullable MessageKey messageKey, @Nullable CommandSender commandSender) {
        Optional<OreConfig> oreConfigOptional = service.getOreConfig(oreConfigName);
        if (oreConfigOptional.isPresent()) {
            return oreConfigOptional.get();
        }
        if (messageKey != null && commandSender != null) {
            messageKey.sendMessage(commandSender, new MessageValue("ore-config", oreConfigName));
        }
        throw new CommandException("OreConfig " + oreConfigName + " not found");
    }
}

