/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command;

import de.derfrzocker.custom.ore.generator.utils.command.CommandUtil;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfoCommand
implements TabExecutor {
    private final BaseComponent[] space = new BaseComponent[]{new TextComponent(" ")};
    @NotNull
    private final Plugin plugin;

    public InfoCommand(@NotNull Plugin plugin) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        CommandUtil.runAsynchronously(sender, this.plugin, () -> {
            BaseComponent[] source = this.buildUrlButton("Source", "https://github.com/DerFrZocker/Custom-Ore-Generator");
            BaseComponent[] discord = this.buildUrlButton("Discord", "http://discord.derfrzocker.de");
            BaseComponent[] patreon = this.buildUrlButton("Patreon", "https://www.patreon.com/woollydevelopment");
            BaseComponent[] spaceSource = InfoCommand.combineBaseComponent(this.space, source);
            BaseComponent[] spaceSourceSpace = InfoCommand.combineBaseComponent(spaceSource, this.space);
            BaseComponent[] spaceSourceSpaceDiscord = InfoCommand.combineBaseComponent(spaceSourceSpace, discord);
            BaseComponent[] spaceSourceSpaceDiscordSpace = InfoCommand.combineBaseComponent(spaceSourceSpaceDiscord, this.space);
            BaseComponent[] spaceSourceSpaceDiscordSpacePatreon = InfoCommand.combineBaseComponent(spaceSourceSpaceDiscordSpace, patreon);
            sender.sendMessage("--- " + ChatColor.BLUE + "Custom-Ore-Generator" + ChatColor.RESET + " ---");
            sender.spigot().sendMessage(spaceSourceSpaceDiscordSpacePatreon);
            sender.sendMessage("    ");
            sender.sendMessage("      Version: " + ChatColor.BLUE + this.plugin.getDescription().getVersion());
            sender.sendMessage("      Author: " + ChatColor.BLUE + (String)this.plugin.getDescription().getAuthors().iterator().next());
            sender.sendMessage("    ");
            sender.sendMessage("--- " + ChatColor.BLUE + "Custom-Ore-Generator" + ChatColor.RESET + " ---");
        });
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        return new ArrayList<String>();
    }

    private BaseComponent[] buildUrlButton(String text, String url) {
        BaseComponent[] begin = new ComponentBuilder("[").color(ChatColor.DARK_RED).create();
        BaseComponent[] end = new ComponentBuilder("]").color(ChatColor.DARK_RED).create();
        BaseComponent[] buttons = TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        BaseComponent[] hoverEventMessage = new ComponentBuilder("Click me").create();
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverEventMessage);
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
        for (BaseComponent button : buttons) {
            button.setHoverEvent(hoverEvent);
            button.setClickEvent(clickEvent);
        }
        BaseComponent[] first = InfoCommand.combineBaseComponent(begin, buttons);
        return InfoCommand.combineBaseComponent(first, end);
    }

    private static BaseComponent[] combineBaseComponent(@NotNull BaseComponent[] baseComponents, BaseComponent ... baseComponents1) {
        int firstLength = baseComponents.length;
        int secondLength = baseComponents1.length;
        BaseComponent[] result = new BaseComponent[firstLength + secondLength];
        System.arraycopy(baseComponents, 0, result, 0, firstLength);
        System.arraycopy(baseComponents1, 0, result, firstLength, secondLength);
        return result;
    }
}

