/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.command;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.api.BlockSelector;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreGenerator;
import de.derfrzocker.custom.ore.generator.factory.OreConfigFactory;
import de.derfrzocker.custom.ore.generator.utils.Version;
import de.derfrzocker.custom.ore.generator.utils.command.CommandUtil;
import de.derfrzocker.custom.ore.generator.utils.message.MessageValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CreateCommand
implements TabExecutor {
    private static final Pattern ORE_CONFIG_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]*$");
    @NotNull
    private final Supplier<CustomOreGeneratorService> serviceSupplier;
    @NotNull
    private final JavaPlugin javaPlugin;
    @NotNull
    private final CustomOreGeneratorMessages messages;

    public CreateCommand(@NotNull Supplier<CustomOreGeneratorService> serviceSupplier, @NotNull JavaPlugin javaPlugin, @NotNull CustomOreGeneratorMessages messages) {
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Validate.notNull((Object)javaPlugin, (String)"JavaPlugin can not be null");
        Validate.notNull((Object)messages, (String)"CustomOreGeneratorMessages can not be null");
        this.serviceSupplier = serviceSupplier;
        this.javaPlugin = javaPlugin;
        this.messages = messages;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0 && sender instanceof Player && Version.getServerVersion(Bukkit.getServer()).isNewerOrSameThan(Version.v1_14_R1)) {
            sender.sendMessage("   ");
            sender.sendMessage(ChatColor.DARK_RED + "This feature is in development!");
            sender.sendMessage(ChatColor.DARK_RED + "It is lacking some feature, information and has some bugs!");
            sender.sendMessage(ChatColor.DARK_RED + "I would highly appreciate it if you send me feedback of this feature.");
            sender.sendMessage(ChatColor.DARK_RED + "e.g. Which part you like, which part you don't like.");
            TextComponent textComponent = new TextComponent(ChatColor.DARK_PURPLE + "discord");
            textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent("<Click me>")}));
            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://discord.derfrzocker.de"));
            sender.spigot().sendMessage(new BaseComponent[]{new TextComponent(ChatColor.DARK_RED + "You can send me feedback by joining my "), textComponent, new TextComponent(ChatColor.DARK_RED + " server")});
            sender.sendMessage(ChatColor.DARK_RED + "Or by sending me a private message over: ");
            textComponent = new TextComponent(ChatColor.DARK_PURPLE + "    SpigotMC" + ChatColor.DARK_RED + " (english)");
            textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent("<Click me>")}));
            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.spigotmc.org/conversations/add?to=DerFrZocker"));
            sender.spigot().sendMessage((BaseComponent)textComponent);
            textComponent = new TextComponent(ChatColor.DARK_PURPLE + "    minecraft-server.eu" + ChatColor.DARK_RED + " (german)");
            textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent("<Click me>")}));
            textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft-server.eu/forum/conversations/add?to=DerFrZocker"));
            sender.spigot().sendMessage((BaseComponent)textComponent);
            sender.spigot().sendMessage((BaseComponent)new TextComponent(ChatColor.DARK_RED + "    Discord:" + ChatColor.DARK_PURPLE + " DerFrZocker#3723"));
            sender.sendMessage("   ");
            OreConfigFactory oreConfigFactory = new OreConfigFactory(this.javaPlugin, this.serviceSupplier, (Player)sender);
            oreConfigFactory.setName();
            return true;
        }
        if (args.length < 2) {
            this.messages.COMMAND_CREATE_NOT_ENOUGH_ARGS.sendMessage(sender, new MessageValue[0]);
            return true;
        }
        CommandUtil.runAsynchronously(sender, (Plugin)this.javaPlugin, () -> {
            BlockSelector blockSelector;
            OreGenerator oreGenerator;
            Material material;
            String configName = args[0];
            String materialName = args[1];
            CustomOreGeneratorService service = this.serviceSupplier.get();
            Optional<OreConfig> oreConfigOptional = service.getOreConfig(configName);
            if (oreConfigOptional.isPresent()) {
                this.messages.COMMAND_CREATE_ALREADY_EXISTS.sendMessage(sender, new MessageValue("ore-config", oreConfigOptional.get().getName()));
                return;
            }
            if (!ORE_CONFIG_NAME_PATTERN.matcher(configName).matches()) {
                this.messages.COMMAND_CREATE_NAME_NOT_VALID.sendMessage(sender, new MessageValue("ore-config", configName));
                return;
            }
            try {
                material = Material.valueOf((String)materialName.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.messages.COMMAND_MATERIAL_NOT_FOUND.sendMessage(sender, new MessageValue("material", materialName));
                return;
            }
            if (!material.isBlock()) {
                this.messages.COMMAND_MATERIAL_NO_BLOCK.sendMessage(sender, new MessageValue("material", materialName));
                return;
            }
            if (args.length >= 3) {
                Optional<OreGenerator> oreGeneratorOptional = service.getOreGenerator(args[2]);
                if (!oreGeneratorOptional.isPresent()) {
                    this.messages.COMMAND_ORE_GENERATOR_NOT_FOUND.sendMessage(sender, new MessageValue("ore-generator", args[2]));
                    return;
                }
                oreGenerator = oreGeneratorOptional.get();
            } else {
                oreGenerator = service.getDefaultOreGenerator();
                Validate.notNull((Object)oreGenerator, (String)"OreGenerator should not be null");
                this.messages.COMMAND_CREATE_ORE_GENERATOR_NOT_SPECIFIED.sendMessage(sender, new MessageValue("ore-generator", oreGenerator.getName()));
            }
            if (args.length >= 4) {
                Optional<BlockSelector> blockSelectorOptional = service.getBlockSelector(args[3]);
                if (!blockSelectorOptional.isPresent()) {
                    this.messages.COMMAND_BLOCK_SELECTOR_NOT_FOUND.sendMessage(sender, new MessageValue("ore-generator", args[3]));
                    return;
                }
                blockSelector = blockSelectorOptional.get();
            } else {
                blockSelector = service.getDefaultBlockSelector();
                Validate.notNull((Object)blockSelector, (String)"BlockSelector should not be null");
                this.messages.COMMAND_CREATE_BLOCK_SELECTOR_NOT_SPECIFIED.sendMessage(sender, new MessageValue("block-selector", blockSelector.getName()));
            }
            OreConfig oreConfig = service.createOreConfig(configName, material, oreGenerator, blockSelector);
            service.saveOreConfig(oreConfig);
            this.messages.COMMAND_CREATE_SUCCESS.sendMessage(sender, new MessageValue("material", material), new MessageValue("ore-config", oreConfig.getName()), new MessageValue("ore-generator", oreGenerator.getName()), new MessageValue("block-selector", blockSelector.getName()));
        });
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        CustomOreGeneratorService service = this.serviceSupplier.get();
        if (args.length == 2) {
            Optional<OreConfig> oreConfig = service.getOreConfig(args[0]);
            if (oreConfig.isPresent()) {
                return list;
            }
            String materialName = args[1].toUpperCase();
            Stream.of(Material.values()).filter(Material::isBlock).map(Enum::toString).filter(value -> value.contains(materialName)).forEach(list::add);
            return list;
        }
        if (args.length == 3) {
            Optional<OreConfig> oreConfig = service.getOreConfig(args[0]);
            if (oreConfig.isPresent()) {
                return list;
            }
            String materialName = args[1].toUpperCase();
            try {
                Material material = Material.valueOf((String)materialName);
                if (!material.isBlock()) {
                    return list;
                }
            }
            catch (IllegalArgumentException e) {
                return list;
            }
            String oreGeneratorName = args[2].toUpperCase();
            service.getOreGenerators().stream().map(OreGenerator::getName).filter(name -> name.contains(oreGeneratorName)).forEach(list::add);
            return list;
        }
        if (args.length == 4) {
            Optional<OreConfig> oreConfig = service.getOreConfig(args[0]);
            if (oreConfig.isPresent()) {
                return list;
            }
            String materialName = args[1].toUpperCase();
            try {
                Material material = Material.valueOf((String)materialName);
                if (!material.isBlock()) {
                    return list;
                }
            }
            catch (IllegalArgumentException e) {
                return list;
            }
            Optional<OreGenerator> optionalOreGenerator = service.getOreGenerator(args[2].toUpperCase());
            if (!optionalOreGenerator.isPresent()) {
                return list;
            }
            String blockSelectorName = args[3].toUpperCase();
            service.getBlockSelectors().stream().map(BlockSelector::getName).filter(name -> name.contains(blockSelectorName)).forEach(list::add);
            return list;
        }
        return list;
    }
}

