/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OreSetting {
    private static final Map<String, OreSetting> ORE_SETTINGS = Collections.synchronizedMap(new HashMap());
    private static final Pattern NAME_PATTER = Pattern.compile("^[A-Z_]*$");
    @NotNull
    private final String name;

    private OreSetting(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can't be null");
        Validate.notEmpty((String)name, (String)"Name can't be empty");
        Validate.isTrue((boolean)NAME_PATTER.matcher(name).matches(), (String)("Name " + name + " doesn't match the regex: ^[A-Z_]*$"));
        this.name = name;
    }

    @Nullable
    public static OreSetting getOreSetting(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can't be null");
        return ORE_SETTINGS.get(name);
    }

    @NotNull
    public static OreSetting createOreSetting(@NotNull String name) {
        Validate.notNull((Object)name, (String)"Name can't be null");
        return ORE_SETTINGS.computeIfAbsent(name, name2 -> new OreSetting(name));
    }

    public static Set<OreSetting> getOreSettings() {
        return new HashSet<OreSetting>(ORE_SETTINGS.values());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof OreSetting)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OreSetting other = (OreSetting)obj;
        return other.getName().equals(this.getName());
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

