/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator;

import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.OreConfig;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.api.customdata.CustomData;
import de.derfrzocker.custom.ore.generator.utils.bukkit.Metrics;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CustomOreGeneratorMetrics {
    public CustomOreGeneratorMetrics(@NotNull Plugin plugin, @NotNull Supplier<CustomOreGeneratorService> serviceSupplier) {
        Validate.notNull((Object)plugin, (String)"Plugin can not be null");
        Validate.notNull(serviceSupplier, (String)"Service supplier can not be null");
        Metrics metrics = new Metrics(plugin);
        metrics.addCustomChart(new Metrics.SingleLineChart("used_in_worlds", () -> ((CustomOreGeneratorService)serviceSupplier.get()).getWorldConfigs().size()));
        metrics.addCustomChart(new Metrics.SingleLineChart("created_ore_configs", () -> ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs().size()));
        metrics.addCustomChart(new Metrics.AdvancedPie("used_material", () -> {
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
            for (OreConfig oreConfig : ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs()) {
                int count = result.getOrDefault(oreConfig.getMaterial().toString(), 0);
                result.put(oreConfig.getMaterial().toString(), count + 1);
            }
            return result;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("used_replace_material", () -> {
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
            for (OreConfig oreConfig : ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs()) {
                for (Material material : oreConfig.getReplaceMaterials()) {
                    int count = result.getOrDefault(material.toString(), 0);
                    result.put(material.toString(), count + 1);
                }
            }
            return result;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("used_select_material", () -> {
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
            for (OreConfig oreConfig : ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs()) {
                for (Material material : oreConfig.getSelectMaterials()) {
                    int count = result.getOrDefault(material.toString(), 0);
                    result.put(material.toString(), count + 1);
                }
            }
            return result;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("used_biomes", () -> {
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
            for (OreConfig oreConfig : ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs()) {
                for (Biome biome : oreConfig.getBiomes()) {
                    int count = result.getOrDefault(biome.toString(), 0);
                    result.put(biome.toString(), count + 1);
                }
            }
            return result;
        }));
        metrics.addCustomChart(new Metrics.AdvancedPie("used_custom_data", () -> {
            LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
            for (OreConfig oreConfig : ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs()) {
                for (CustomData customData : oreConfig.getCustomData().keySet()) {
                    int count = result.getOrDefault(customData.getName(), 0);
                    result.put(customData.getName(), count + 1);
                }
            }
            return result;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("used_ore_generator", () -> {
            LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
            for (OreConfig oreConfig : ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs()) {
                String oreGenerator = oreConfig.getOreGenerator();
                Map settingsMap = result.computeIfAbsent(oreGenerator, name -> new LinkedHashMap());
                settingsMap.put("used", settingsMap.getOrDefault("used", 0) + 1);
                for (OreSetting oreSetting : oreConfig.getOreGeneratorOreSettings().getValues().keySet()) {
                    int count = settingsMap.getOrDefault(oreSetting.getName(), 0);
                    settingsMap.put(oreSetting.getName(), count + 1);
                }
            }
            return result;
        }));
        metrics.addCustomChart(new Metrics.DrilldownPie("used_block_selector", () -> {
            LinkedHashMap<String, Map> result = new LinkedHashMap<String, Map>();
            for (OreConfig oreConfig : ((CustomOreGeneratorService)serviceSupplier.get()).getOreConfigs()) {
                String blockSelector = oreConfig.getBlockSelector();
                Map settingsMap = result.computeIfAbsent(blockSelector, name -> new LinkedHashMap());
                settingsMap.put("used", settingsMap.getOrDefault("used", 0) + 1);
                for (OreSetting oreSetting : oreConfig.getBlockSelectorOreSettings().getValues().keySet()) {
                    int count = settingsMap.getOrDefault(oreSetting.getName(), 0);
                    settingsMap.put(oreSetting.getName(), count + 1);
                }
            }
            return result;
        }));
        if (!metrics.isEnabled()) {
            plugin.getLogger().warning("meh");
        }
    }
}

