/*
 * Decompiled with CFR 0.152.
 */
package de.derfrzocker.custom.ore.generator;

import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMessages;
import de.derfrzocker.custom.ore.generator.CustomOreGeneratorMetrics;
import de.derfrzocker.custom.ore.generator.Permissions;
import de.derfrzocker.custom.ore.generator.api.CustomOreGeneratorService;
import de.derfrzocker.custom.ore.generator.api.Info;
import de.derfrzocker.custom.ore.generator.api.OreSetting;
import de.derfrzocker.custom.ore.generator.command.OreGenCommand;
import de.derfrzocker.custom.ore.generator.impl.BiomeConfigYamlImpl;
import de.derfrzocker.custom.ore.generator.impl.CustomOreGeneratorServiceImpl;
import de.derfrzocker.custom.ore.generator.impl.OreConfigYamlImpl;
import de.derfrzocker.custom.ore.generator.impl.OreSettingsContainerYamlImpl;
import de.derfrzocker.custom.ore.generator.impl.WorldConfigYamlImpl;
import de.derfrzocker.custom.ore.generator.impl.blockselector.CountRangeBlockSelector;
import de.derfrzocker.custom.ore.generator.impl.blockselector.HighestBlockBlockSelector;
import de.derfrzocker.custom.ore.generator.impl.customdata.AutoCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.BlockStateCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.CommandCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.DirectionCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.FacingCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.ItemModsCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.NBTTagCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.OraxenCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.SkullTextureCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.TickBlockCustomData;
import de.derfrzocker.custom.ore.generator.impl.customdata.VariantCustomData;
import de.derfrzocker.custom.ore.generator.impl.dao.OreConfigYamlDao;
import de.derfrzocker.custom.ore.generator.impl.dao.WorldConfigYamlDao;
import de.derfrzocker.custom.ore.generator.impl.dao.WorldConfigYamlDao_Old;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.GlowStoneGenerator;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.RootGenerator;
import de.derfrzocker.custom.ore.generator.impl.oregenerator.SingleOreGenerator;
import de.derfrzocker.custom.ore.generator.impl.v1_10_R1.CustomOreBlockPopulator_v1_10_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_10_R1.oregenerator.MinableGenerator_v1_10_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_11_R1.CustomOreBlockPopulator_v1_11_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_11_R1.oregenerator.MinableGenerator_v1_11_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_12_R1.CustomOreBlockPopulator_v1_12_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_12_R1.oregenerator.MinableGenerator_v1_12_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R1.WorldHandler_v1_13_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R1.oregenerator.MinableGenerator_v1_13_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.WorldHandler_v1_13_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.oregenerator.MinableGenerator_v1_13_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.paper.WorldHandler_v1_13_R2_paper;
import de.derfrzocker.custom.ore.generator.impl.v1_13_R2.paper.oregenerator.MinableGenerator_v1_13_R2_paper;
import de.derfrzocker.custom.ore.generator.impl.v1_14_R1.WorldHandler_v1_14_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_14_R1.oregenerator.MinableGenerator_v1_14_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.WorldHandler_v1_15_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_15_R1.oregenerator.MinableGenerator_v1_15_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R1.WorldHandler_v1_16_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R1.oregenerator.MinableGenerator_v1_16_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.WorldHandler_v1_16_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R2.oregenerator.MinableGenerator_v1_16_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R3.WorldHandler_v1_16_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_16_R3.oregenerator.MinableGenerator_v1_16_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.WorldHandler_v1_17_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_17_R1.oregenerator.MinableGenerator_v1_17_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R1.WorldHandler_v1_18_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R1.oregenerator.MinableGenerator_v1_18_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R2.WorldHandler_v1_18_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_18_R2.oregenerator.MinableGenerator_v1_18_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R1.WorldHandler_v1_19_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R1.oregenerator.MinableGenerator_v1_19_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R2.WorldHandler_v1_19_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R2.oregenerator.MinableGenerator_v1_19_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R3.WorldHandler_v1_19_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_19_R3.oregenerator.MinableGenerator_v1_19_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_8_R1.CustomOreBlockPopulator_v1_8_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_8_R1.oregenerator.MinableGenerator_v1_8_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_8_R2.CustomOreBlockPopulator_v1_8_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_8_R2.oregenerator.MinableGenerator_v1_8_R2;
import de.derfrzocker.custom.ore.generator.impl.v1_8_R3.CustomOreBlockPopulator_v1_8_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_8_R3.oregenerator.MinableGenerator_v1_8_R3;
import de.derfrzocker.custom.ore.generator.impl.v1_9_R1.CustomOreBlockPopulator_v1_9_R1;
import de.derfrzocker.custom.ore.generator.impl.v1_9_R1.oregenerator.MinableGenerator_v1_9_R1;
import de.derfrzocker.custom.ore.generator.impl.v_1_9_R2.CustomOreBlockPopulator_v1_9_R2;
import de.derfrzocker.custom.ore.generator.impl.v_1_9_R2.oregenerator.MinableGenerator_v1_9_R2;
import de.derfrzocker.custom.ore.generator.utils.Config;
import de.derfrzocker.custom.ore.generator.utils.InfoUtil;
import de.derfrzocker.custom.ore.generator.utils.RegisterUtil;
import de.derfrzocker.custom.ore.generator.utils.Version;
import java.io.File;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class CustomOreGenerator
extends JavaPlugin {
    private CustomOreGeneratorMessages messages;
    private Permissions permissions;
    private Version version = Version.UNKNOWN;
    private boolean shouldLoad = true;

    public void onLoad() {
        this.version = Version.getServerVersion(this.getServer());
        if (this.version == Version.UNKNOWN) {
            this.getLogger().warning("The Server version which you are running is unsupported, you are running version '" + this.version + "'");
            this.getLogger().warning("The plugin supports following versions " + this.combineVersions(Version.v1_8_R1, Version.v1_8_R2, Version.v1_8_R3, Version.v1_9_R1, Version.v1_9_R2, Version.v1_10_R1, Version.v1_11_R1, Version.v1_12_R1, Version.v1_13_R1, Version.v1_13_R2, Version.v1_14_R1, Version.v1_15_R1, Version.v1_16_R1, Version.v1_16_R2, Version.v1_16_R3, Version.v1_17_R1, Version.v1_18_R1, Version.v1_18_R2, Version.v1_19_R1, Version.v1_19_R2, Version.v1_19_R3));
            this.getLogger().warning("(Spigot / Paper version 1.8 - 1.19.4), if you are running such a Minecraft version, than your bukkit implementation is unsupported, in this case please contact the developer, so he can resolve this Issue");
            if (this.version == Version.UNKNOWN) {
                this.getLogger().warning("The Version '" + this.version + "' can indicate, that you are using a newer Minecraft version than currently supported.");
                this.getLogger().warning("In this case please update to the newest version of this plugin. If this is the newest Version, than please be patient. It can take some weeks until the plugin is updated");
            }
            this.shouldLoad = false;
            return;
        }
        if (this.version == Version.v1_17_R1) {
            try {
                Class.forName("org.bukkit.generator.WorldInfo");
            }
            catch (ClassNotFoundException e) {
                this.shouldLoad = false;
                this.getLogger().warning("The server version which you are running is unsupported");
                this.getLogger().warning("Make sure that you are running 1.17.1 Spigot build 3218 or higher, 1.17 is not supported.");
                return;
            }
        }
        this.messages = new CustomOreGeneratorMessages(this);
        this.permissions = new Permissions(this);
        WorldConfigYamlDao worldConfigYamlDao = new WorldConfigYamlDao(new File(this.getDataFolder(), "data/world-config"));
        OreConfigYamlDao oreConfigYamlDao = new OreConfigYamlDao(new File(this.getDataFolder(), "data/ore-config"));
        CustomOreGeneratorServiceImpl service = new CustomOreGeneratorServiceImpl(worldConfigYamlDao, oreConfigYamlDao, this.getLogger());
        this.getServer().getServicesManager().register(CustomOreGeneratorService.class, (Object)service, (Plugin)this, ServicePriority.Normal);
        oreConfigYamlDao.init();
        worldConfigYamlDao.init();
        this.checkOldStorageType();
    }

    public void onEnable() {
        if (this.version == Version.UNKNOWN || !this.shouldLoad) {
            this.getLogger().log(Level.WARNING, "No compatible Server version found!", new IllegalStateException("No compatible Server version found!"));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getCommand("oregen").setExecutor((CommandExecutor)new OreGenCommand(CustomOreGeneratorServiceSupplier.INSTANCE, this, this.messages, this.permissions));
        if (this.version.isNewerOrSameThan(Version.v1_14_R1)) {
            this.checkFile("data/factory/gui/menu-gui.yml");
        }
        this.checkFile("data/factory/gui/biome-gui.yml");
        RegisterUtil registerUtil = new RegisterUtil((Plugin)this, CustomOreGeneratorServiceSupplier.INSTANCE.get(), this.version, Version.isPaper(this.getServer()));
        this.initWorldHandler();
        this.registerStandardOreGenerators(registerUtil);
        this.registerStandardBlockSelector(registerUtil);
        this.registerStandardCustomDatas(registerUtil);
        new CustomOreGeneratorMetrics((Plugin)this, CustomOreGeneratorServiceSupplier.INSTANCE);
        CustomOreGeneratorService service = CustomOreGeneratorServiceSupplier.INSTANCE.get();
        service.getOreConfigs().forEach(service::saveOreConfig);
        service.getWorldConfigs().forEach(service::saveWorldConfig);
    }

    private void registerStandardOreGenerators(@NotNull RegisterUtil registerUtil) {
        Function<String, Info> infoFunction = name -> InfoUtil.getOreGeneratorInfo(this, name);
        BiFunction<String, OreSetting, Info> oreSettingInfoBiFunction = (name, oreSetting) -> InfoUtil.getOreGeneratorOreSettingInfo(this, name, oreSetting);
        registerUtil.register(new GlowStoneGenerator(infoFunction, oreSettingInfoBiFunction));
        registerUtil.register(new RootGenerator(infoFunction, oreSettingInfoBiFunction));
        registerUtil.register(new SingleOreGenerator(infoFunction, oreSettingInfoBiFunction));
        registerUtil.register(Version.v1_8_R1, Version.v1_8_R1, () -> new MinableGenerator_v1_8_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_8_R2, Version.v1_8_R2, () -> new MinableGenerator_v1_8_R2(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_8_R3, Version.v1_8_R3, () -> new MinableGenerator_v1_8_R3(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_9_R1, Version.v1_9_R1, () -> new MinableGenerator_v1_9_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_9_R2, Version.v1_9_R2, () -> new MinableGenerator_v1_9_R2(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_10_R1, Version.v1_10_R1, () -> new MinableGenerator_v1_10_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_11_R1, Version.v1_11_R1, () -> new MinableGenerator_v1_11_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_12_R1, Version.v1_12_R1, () -> new MinableGenerator_v1_12_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_13_R1, Version.v1_13_R1, () -> new MinableGenerator_v1_13_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_13_R2, Version.v1_13_R2, false, () -> new MinableGenerator_v1_13_R2(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_13_R2, Version.v1_13_R2, true, () -> new MinableGenerator_v1_13_R2_paper(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_14_R1, Version.v1_14_R1, () -> new MinableGenerator_v1_14_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_15_R1, Version.v1_15_R1, () -> new MinableGenerator_v1_15_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_16_R1, Version.v1_16_R1, () -> new MinableGenerator_v1_16_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_16_R2, Version.v1_16_R2, () -> new MinableGenerator_v1_16_R2(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_16_R3, Version.v1_16_R3, () -> new MinableGenerator_v1_16_R3(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_17_R1, Version.v1_17_R1, () -> new MinableGenerator_v1_17_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_18_R1, Version.v1_18_R1, () -> new MinableGenerator_v1_18_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_18_R2, Version.v1_18_R2, () -> new MinableGenerator_v1_18_R2(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_19_R1, Version.v1_19_R1, () -> new MinableGenerator_v1_19_R1(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_19_R2, Version.v1_19_R2, () -> new MinableGenerator_v1_19_R2(infoFunction, oreSettingInfoBiFunction), true);
        registerUtil.register(Version.v1_19_R3, Version.v1_19_R3, () -> new MinableGenerator_v1_19_R3(infoFunction, oreSettingInfoBiFunction), true);
    }

    private void registerStandardBlockSelector(@NotNull RegisterUtil registerUtil) {
        Function<String, Info> infoFunction = name -> InfoUtil.getBlockSelectorInfo(this, name);
        BiFunction<String, OreSetting, Info> oreSettingInfoBiFunction = (name, oreSetting) -> InfoUtil.getBlockSelectorOreSettingInfo(this, name, oreSetting);
        registerUtil.register(new HighestBlockBlockSelector(infoFunction, oreSettingInfoBiFunction));
        registerUtil.register(new CountRangeBlockSelector(infoFunction, oreSettingInfoBiFunction), true);
    }

    private void registerStandardCustomDatas(@NotNull RegisterUtil registerUtil) {
        Function<String, Info> infoFunction = name -> InfoUtil.getCustomDataInfo(this, name);
        File fileFolder = new File(this.getDataFolder(), "files");
        registerUtil.register(new SkullTextureCustomData(infoFunction));
        registerUtil.register(new CommandCustomData(infoFunction));
        registerUtil.register(new NBTTagCustomData(infoFunction, fileFolder));
        registerUtil.register(Version.v1_9_R1, () -> new AutoCustomData(infoFunction));
        registerUtil.register(Version.v1_10_R1, () -> new BlockStateCustomData(CustomOreGeneratorServiceSupplier.INSTANCE, infoFunction, fileFolder));
        registerUtil.register(Version.v1_8_R1, Version.v1_12_R1, () -> new VariantCustomData(infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new TickBlockCustomData(infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new FacingCustomData(infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new DirectionCustomData(BlockFace.DOWN, infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new DirectionCustomData(BlockFace.UP, infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new DirectionCustomData(BlockFace.NORTH, infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new DirectionCustomData(BlockFace.SOUTH, infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new DirectionCustomData(BlockFace.EAST, infoFunction));
        registerUtil.register(Version.v1_13_R1, () -> new DirectionCustomData(BlockFace.WEST, infoFunction));
        registerUtil.register(Version.v1_14_R1, "ItemMods", () -> new ItemModsCustomData(infoFunction));
        registerUtil.register(Version.v1_14_R1, "Oraxen", () -> new OraxenCustomData(infoFunction));
    }

    private void initWorldHandler() {
        switch (this.version) {
            case v1_19_R3: {
                new WorldHandler_v1_19_R3(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                break;
            }
            case v1_19_R2: {
                new WorldHandler_v1_19_R2(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                break;
            }
            case v1_19_R1: {
                new WorldHandler_v1_19_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                break;
            }
            case v1_18_R2: {
                new WorldHandler_v1_18_R2(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                break;
            }
            case v1_18_R1: {
                new WorldHandler_v1_18_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_17_R1: {
                new WorldHandler_v1_17_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_16_R3: {
                new WorldHandler_v1_16_R3(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_16_R2: {
                new WorldHandler_v1_16_R2(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_16_R1: {
                new WorldHandler_v1_16_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_15_R1: {
                new WorldHandler_v1_15_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_14_R1: {
                new WorldHandler_v1_14_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_13_R2: {
                if (Version.isPaper(this.getServer())) {
                    new WorldHandler_v1_13_R2_paper(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                } else {
                    new WorldHandler_v1_13_R2(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                }
                return;
            }
            case v1_13_R1: {
                new WorldHandler_v1_13_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_12_R1: {
                new CustomOreBlockPopulator_v1_12_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_11_R1: {
                new CustomOreBlockPopulator_v1_11_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_10_R1: {
                new CustomOreBlockPopulator_v1_10_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_9_R2: {
                new CustomOreBlockPopulator_v1_9_R2(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_9_R1: {
                new CustomOreBlockPopulator_v1_9_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_8_R3: {
                new CustomOreBlockPopulator_v1_8_R3(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_8_R2: {
                new CustomOreBlockPopulator_v1_8_R2(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
            case v1_8_R1: {
                new CustomOreBlockPopulator_v1_8_R1(this, CustomOreGeneratorServiceSupplier.INSTANCE);
                return;
            }
        }
    }

    @Deprecated
    private void checkOldStorageType() {
        File file = new File(this.getDataFolder(), "data/world_configs.yml");
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.getLogger().info("WTF?? why??");
            return;
        }
        this.getLogger().info("Found old storage type, convert to new one");
        WorldConfigYamlDao_Old worldConfigYamlDao = new WorldConfigYamlDao_Old(new File(this.getDataFolder(), "data/world_configs.yml"));
        worldConfigYamlDao.init();
        if (!file.delete()) {
            throw new RuntimeException("Can not delete File " + file);
        }
        this.getLogger().info("Finish converting old storage format to new one");
    }

    private void checkFile(@NotNull String name) {
        File file = new File(this.getDataFolder(), name);
        if (!file.exists()) {
            return;
        }
        Config configuration = new Config(file);
        Config configuration2 = new Config(this.getResource(name));
        if (configuration.getInt("version") == configuration2.getInt("version")) {
            return;
        }
        this.getLogger().warning("File " + name + " has an outdated / new version, replacing it!");
        if (!file.delete()) {
            throw new RuntimeException("can't delete file " + name + " stop plugin start!");
        }
        this.saveResource(name, true);
    }

    private String combineVersions(Version ... versions) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (Version version : versions) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(" ");
            }
            stringBuilder.append("'");
            stringBuilder.append(version);
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    static {
        ConfigurationSerialization.registerClass(BiomeConfigYamlImpl.class);
        ConfigurationSerialization.registerClass(OreConfigYamlImpl.class);
        ConfigurationSerialization.registerClass(WorldConfigYamlImpl.class);
        ConfigurationSerialization.registerClass(OreSettingsContainerYamlImpl.class);
    }

    private static final class CustomOreGeneratorServiceSupplier
    implements Supplier<CustomOreGeneratorService> {
        private static final CustomOreGeneratorServiceSupplier INSTANCE = new CustomOreGeneratorServiceSupplier();
        private CustomOreGeneratorService service;

        private CustomOreGeneratorServiceSupplier() {
        }

        @Override
        public CustomOreGeneratorService get() {
            CustomOreGeneratorService tempService = (CustomOreGeneratorService)Bukkit.getServicesManager().load(CustomOreGeneratorService.class);
            if (this.service == null && tempService == null) {
                throw new NullPointerException("The Bukkit Service has no CustomOreGeneratorService and no CustomOreGeneratorService is cached!");
            }
            if (tempService != null && this.service != tempService) {
                this.service = tempService;
            }
            return this.service;
        }
    }
}

