/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.libs.utils.common.ConfigFile;
import us.ajg0702.queue.spigot.Commands;
import us.ajg0702.queue.spigot.Placeholders;
import us.ajg0702.queue.spigot.QueueScoreboardActivator;

public class SpigotMain
extends JavaPlugin
implements PluginMessageListener,
Listener {
    private boolean papi = false;
    private Placeholders placeholders;
    private ConfigFile config;
    private boolean hasProxy = false;
    final HashMap<Player, String> queuebatch = new HashMap();

    public void onEnable() {
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "ajqueue:tospigot", (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "ajqueue:toproxy");
        this.getCommand("move").setExecutor((CommandExecutor)new Commands(this));
        this.getCommand("leavequeue").setExecutor((CommandExecutor)new Commands(this));
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        boolean bl = this.papi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
        if (this.papi) {
            this.placeholders = new Placeholders(this);
            this.placeholders.register();
            this.getLogger().info("Registered PlaceholderAPI placeholders");
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            if (Bukkit.getOnlinePlayers().size() <= 0 || this.queuebatch.size() <= 0) {
                return;
            }
            StringBuilder msg = new StringBuilder();
            for (Player p : this.queuebatch.keySet()) {
                if (p == null || !p.isOnline()) continue;
                msg.append(p.getName()).append(":").append(this.queuebatch.get(p)).append(",");
            }
            if (msg.length() > 1) {
                msg = new StringBuilder(msg.substring(0, msg.length() - 1));
            }
            this.queuebatch.clear();
            this.sendMessage("massqueue", msg.toString());
        }, 40L, 20L);
        File oldConfig = new File(this.getDataFolder(), "config.yml");
        if (oldConfig.exists()) {
            oldConfig.renameTo(new File(this.getDataFolder(), "spigot-config.yml"));
        }
        try {
            this.config = new ConfigFile(this.getDataFolder(), this.getLogger(), "spigot-config.yml");
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to read config:");
            e.printStackTrace();
        }
        this.getLogger().info("Spigot side enabled! v" + this.getDescription().getVersion());
    }

    public boolean hasProxy() {
        return this.hasProxy;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte[] message) {
        HashMap<String, String> phs;
        Player p;
        HashMap<String, String> phs2;
        String data;
        Player p2;
        String playername;
        if (!channel.equals("ajqueue:tospigot")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subchannel = in.readUTF();
        if (subchannel.equals("ack")) {
            this.hasProxy = true;
        }
        if (subchannel.equals("inqueueevent")) {
            playername = in.readUTF();
            p2 = Bukkit.getPlayer((String)playername);
            if (p2 == null) {
                return;
            }
            QueueScoreboardActivator e = new QueueScoreboardActivator(p2);
            Bukkit.getPluginManager().callEvent((Event)e);
        }
        if (subchannel.equals("queuename") && this.papi) {
            playername = in.readUTF();
            p2 = Bukkit.getPlayer((String)playername);
            if (p2 == null) {
                return;
            }
            if (!p2.isOnline()) {
                return;
            }
            data = in.readUTF();
            phs2 = this.placeholders.responseCache.get(p2);
            if (phs2 == null) {
                phs2 = new HashMap();
            }
            phs2.put("queued", data);
            this.placeholders.responseCache.put(p2, phs2);
        }
        if (subchannel.equals("position") && this.papi) {
            playername = in.readUTF();
            p2 = Bukkit.getPlayer((String)playername);
            if (p2 == null) {
                return;
            }
            if (!p2.isOnline()) {
                return;
            }
            data = in.readUTF();
            phs2 = this.placeholders.responseCache.get(p2);
            if (phs2 == null) {
                phs2 = new HashMap();
            }
            phs2.put("position", data);
            this.placeholders.responseCache.put(p2, phs2);
        }
        if (subchannel.equals("positionof") && this.papi) {
            playername = in.readUTF();
            p2 = Bukkit.getPlayer((String)playername);
            if (p2 == null) {
                return;
            }
            if (!p2.isOnline()) {
                return;
            }
            data = in.readUTF();
            phs2 = this.placeholders.responseCache.get(p2);
            if (phs2 == null) {
                phs2 = new HashMap();
            }
            phs2.put("of", data);
            this.placeholders.responseCache.put(p2, phs2);
        }
        if (subchannel.equals("inqueue") && this.papi) {
            playername = in.readUTF();
            p2 = Bukkit.getPlayer((String)playername);
            if (p2 == null) {
                return;
            }
            if (!p2.isOnline()) {
                return;
            }
            data = in.readUTF();
            phs2 = this.placeholders.responseCache.get(p2);
            if (phs2 == null) {
                phs2 = new HashMap();
            }
            phs2.put("inqueue", data);
            this.placeholders.responseCache.put(p2, phs2);
        }
        if (subchannel.equals("queuedfor")) {
            playername = in.readUTF();
            String queuename = in.readUTF();
            p = Bukkit.getPlayer((String)playername);
            if (p == null) {
                return;
            }
            if (!p.isOnline()) {
                return;
            }
            int number = Integer.parseInt(in.readUTF());
            phs = this.placeholders.responseCache.get(p);
            if (phs == null) {
                phs = new HashMap();
            }
            phs.put("queuedfor_" + queuename, number + "");
            this.placeholders.responseCache.put(p, phs);
        }
        if (subchannel.equals("estimated_time")) {
            playername = in.readUTF();
            p2 = Bukkit.getPlayer((String)playername);
            if (p2 == null) {
                return;
            }
            if (!p2.isOnline()) {
                return;
            }
            String time = in.readUTF();
            HashMap<String, String> phs3 = this.placeholders.responseCache.get(p2);
            if (phs3 == null) {
                phs3 = new HashMap();
            }
            phs3.put("estimated_time", time);
            this.placeholders.responseCache.put(p2, phs3);
        }
        if (subchannel.equals("status")) {
            playername = in.readUTF();
            String server = in.readUTF();
            p = Bukkit.getPlayer((String)playername);
            if (p == null) {
                return;
            }
            if (!p.isOnline()) {
                return;
            }
            String status = in.readUTF();
            phs = this.placeholders.responseCache.get(p);
            if (phs == null) {
                phs = new HashMap();
            }
            phs.put("status_" + server, status + "");
            this.placeholders.responseCache.put(p, phs);
        }
    }

    public void sendMessage(Player player, String subchannel, String data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(subchannel);
        out.writeUTF(data);
        player.sendPluginMessage((Plugin)this, "ajqueue:toproxy", out.toByteArray());
    }

    public void sendMessage(String subchannel, String data) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(subchannel);
        out.writeUTF(data);
        ((Player)Bukkit.getOnlinePlayers().iterator().next()).sendPluginMessage((Plugin)this, "ajqueue:toproxy", out.toByteArray());
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        if (!this.papi) {
            return;
        }
        this.placeholders.cleanCache();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (this.hasProxy) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.sendMessage(e.getPlayer(), "ack", ""));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onServerPing(ServerListPingEvent e) {
        if (this.config == null) {
            this.getLogger().warning("Server ping before plugin load!");
            return;
        }
        if (!this.config.getBoolean("take-over-motd-for-whitelist")) {
            return;
        }
        if (!Bukkit.hasWhitelist()) {
            return;
        }
        StringBuilder whitelist = new StringBuilder();
        for (OfflinePlayer player : Bukkit.getWhitelistedPlayers()) {
            whitelist.append(player.getUniqueId()).append(",");
        }
        if (whitelist.length() > 1) {
            whitelist.deleteCharAt(whitelist.length() - 1);
        }
        e.setMotd("ajQueue;whitelisted=" + whitelist);
    }

    public ConfigFile getAConfig() {
        return this.config;
    }
}

