/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.spigot;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import us.ajg0702.queue.spigot.SpigotMain;

public class Placeholders
extends PlaceholderExpansion {
    private final SpigotMain plugin;
    final HashMap<Player, HashMap<String, String>> responseCache = new HashMap();

    public Placeholders(SpigotMain plugin) {
        this.plugin = plugin;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getIdentifier() {
        return "ajqueue";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public void cleanCache() {
        Iterator<Player> it = this.responseCache.keySet().iterator();
        while (it.hasNext()) {
            Player p = it.next();
            if (p == null) {
                it.remove();
                continue;
            }
            if (p.isOnline()) continue;
            it.remove();
        }
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "No player";
        }
        String noc = "_nocache";
        if (identifier.length() > noc.length()) {
            int olen = identifier.length() - noc.length();
            if (identifier.indexOf(noc) == olen) {
                String idfr = identifier.substring(0, olen);
                return this.parsePlaceholder(player, idfr);
            }
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String resp;
            HashMap<Object, Object> playerCache = this.responseCache.containsKey(player) ? this.responseCache.get(player) : new HashMap();
            if (playerCache.size() > 75) {
                try {
                    playerCache.remove(playerCache.keySet().toArray()[0]);
                }
                catch (ConcurrentModificationException e) {
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> playerCache.remove(playerCache.keySet().toArray()[0]));
                }
            }
            if ((resp = this.parsePlaceholder(player, identifier)) == null) {
                return;
            }
            playerCache.put(identifier, resp);
            this.responseCache.put(player, playerCache);
        });
        if (this.responseCache.containsKey(player)) {
            HashMap<String, String> playerCache = this.responseCache.get(player);
            if (playerCache.containsKey(identifier)) {
                return playerCache.get(identifier);
            }
        } else {
            if (identifier.equalsIgnoreCase("queued")) {
                return "None";
            }
            if (identifier.equalsIgnoreCase("position") || identifier.equalsIgnoreCase("of")) {
                return "None";
            }
            if (identifier.equalsIgnoreCase("inqueue")) {
                return "false";
            }
            if (identifier.matches("queuedfor_*.*")) {
                return "0";
            }
            if (identifier.matches("status_*.*")) {
                return "Loading";
            }
        }
        return null;
    }

    private String parsePlaceholder(Player player, String identifier) {
        if (identifier.equalsIgnoreCase("queued")) {
            this.plugin.sendMessage(player, "queuename", "");
        } else if (identifier.equalsIgnoreCase("position")) {
            this.plugin.sendMessage(player, "position", "");
        } else if (identifier.equalsIgnoreCase("of")) {
            this.plugin.sendMessage(player, "positionof", "");
        } else if (identifier.equalsIgnoreCase("inqueue")) {
            this.plugin.sendMessage(player, "inqueue", "");
        } else if (identifier.equalsIgnoreCase("estimated_time")) {
            this.plugin.sendMessage(player, "estimated_time", "");
        } else if (identifier.matches("queuedfor_*.*")) {
            this.plugin.sendMessage(player, "queuedfor", identifier.split("_")[1]);
        } else if (identifier.matches("status_*.*")) {
            this.plugin.sendMessage(player, "status", identifier.split("_")[1]);
        }
        return null;
    }
}

