/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity.server;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import us.ajg0702.queue.api.AjQueueAPI;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.server.AdaptedServerInfo;
import us.ajg0702.queue.api.server.AdaptedServerPing;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.platforms.velocity.players.VelocityPlayer;
import us.ajg0702.queue.platforms.velocity.server.VelocityServerInfo;
import us.ajg0702.queue.platforms.velocity.server.VelocityServerPing;

public class VelocityServer
implements AdaptedServer {
    private final RegisteredServer handle;
    private AdaptedServerPing lastPing = null;
    private AdaptedServerPing lastSuccessfullPing = null;
    private long lastOffline = 0L;
    private int offlineTime = 0;

    public VelocityServer(RegisteredServer handle) {
        this.handle = handle;
    }

    @Override
    public AdaptedServerInfo getServerInfo() {
        return new VelocityServerInfo(this.handle.getServerInfo());
    }

    @Override
    public String getName() {
        return this.handle.getServerInfo().getName();
    }

    @Override
    public CompletableFuture<AdaptedServerPing> ping(boolean debug, QueueLogger logger) {
        CompletableFuture<AdaptedServerPing> future = new CompletableFuture<AdaptedServerPing>();
        long sent = System.currentTimeMillis();
        CompletableFuture serverPing = this.handle.ping();
        if (debug) {
            logger.info("[pinger] [" + this.getName() + "] sending ping");
        }
        ((CompletableFuture)serverPing.thenRunAsync(() -> {
            VelocityServerPing ping;
            try {
                ping = new VelocityServerPing((ServerPing)serverPing.get(), sent);
            }
            catch (Throwable e) {
                this.markOffline(debug, logger, future, sent, e);
                return;
            }
            this.offlineTime = 0;
            this.lastSuccessfullPing = ping;
            if (debug) {
                logger.info("[pinger] [" + this.getName() + "] online. motd: " + ping.getPlainDescription() + "  players: " + ping.getPlayerCount() + "/" + ping.getMaxPlayers());
            }
            future.complete(ping);
            this.lastPing = ping;
        })).exceptionally(e -> {
            this.markOffline(debug, logger, future, sent, (Throwable)e);
            return null;
        });
        return future;
    }

    private void markOffline(boolean debug, QueueLogger logger, CompletableFuture<AdaptedServerPing> future, long sent, Throwable e) {
        long lastOnline = this.lastSuccessfullPing == null ? 0L : this.lastSuccessfullPing.getFetchedTime();
        this.offlineTime = (int)Math.min(sent - lastOnline, Integer.MAX_VALUE);
        this.lastOffline = sent;
        future.completeExceptionally(e);
        this.lastPing = null;
        if (debug) {
            logger.info("[pinger] [" + this.getName() + "] offline:", e);
        }
    }

    @Override
    public Optional<AdaptedServerPing> getLastPing() {
        return Optional.ofNullable(this.lastPing);
    }

    @Override
    public boolean canAccess(AdaptedPlayer player) {
        return true;
    }

    @Override
    public List<AdaptedPlayer> getPlayers() {
        ArrayList<AdaptedPlayer> players = new ArrayList<AdaptedPlayer>();
        for (Player player : this.handle.getPlayersConnected()) {
            players.add(new VelocityPlayer(player));
        }
        return players;
    }

    @Override
    public int getOfflineTime() {
        return this.offlineTime;
    }

    @Override
    public boolean canJoinFull(AdaptedPlayer player) {
        if (player == null) {
            return true;
        }
        Debug.info("on " + this.getName());
        return player.hasPermission("ajqueue.joinfull") || player.hasPermission("ajqueue.joinfullserver." + this.getName()) || player.hasPermission("ajqueue.joinfullandbypassserver." + this.getName()) || player.hasPermission("ajqueue.joinfullandbypass") || AjQueueAPI.getInstance().isPremium() && AjQueueAPI.getInstance().getLogic().getPermissionGetter().hasUniqueFullBypass(player, this.getName());
    }

    @Override
    public boolean justWentOnline() {
        return (double)(System.currentTimeMillis() - this.lastOffline) <= AjQueueAPI.getInstance().getConfig().getDouble("wait-time") * 2.0 * 1000.0 && this.isOnline();
    }

    public RegisteredServer getHandle() {
        return this.handle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VelocityServer)) {
            return false;
        }
        VelocityServer that = (VelocityServer)o;
        return this.getHandle().equals(that.getHandle());
    }

    public int hashCode() {
        return Objects.hash(this.getHandle());
    }
}

