/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.velocity.players;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.viaversion.viaversion.api.Via;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.utils.Debug;

public class VelocityPlayer
implements AdaptedPlayer,
Audience {
    final Player handle;
    private final boolean viaAvailable;

    @Override
    public void showTitle(@NotNull Title title) {
        this.handle.showTitle(title);
    }

    @Override
    public void clearTitle() {
        this.handle.clearTitle();
    }

    @Override
    public void resetTitle() {
        this.handle.resetTitle();
    }

    @Override
    public void showBossBar(@NotNull BossBar bar) {
        this.handle.showBossBar(bar);
    }

    @Override
    public void hideBossBar(@NotNull BossBar bar) {
        this.handle.hideBossBar(bar);
    }

    @Override
    public void playSound(@NotNull Sound sound) {
        this.handle.playSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.handle.playSound(sound, x, y, z);
    }

    @Override
    public void stopSound(@NotNull Sound sound) {
        this.handle.stopSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
        this.handle.playSound(sound, emitter);
    }

    @Override
    public void stopSound(@NotNull SoundStop stop) {
        this.handle.stopSound(stop);
    }

    public VelocityPlayer(Player player) {
        this.handle = player;
        this.viaAvailable = VelocityPlayer.isClassAvailable("com.viaversion.viaversion.api.Via");
    }

    @Override
    public boolean isConnected() {
        return this.handle.isActive();
    }

    @Override
    public void sendMessage(@NotNull Component message) {
        if (PlainTextComponentSerializer.plainText().serialize(message).isEmpty()) {
            return;
        }
        this.handle.sendMessage(message);
    }

    @Override
    public void sendActionBar(@NotNull Component message) {
        this.handle.sendActionBar(message);
    }

    @Override
    public void sendMessage(String message) {
        this.sendMessage(Component.text(message));
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.handle.hasPermission(permission);
    }

    @Override
    public String getServerName() {
        Optional serverConnection = this.handle.getCurrentServer();
        if (!serverConnection.isPresent()) {
            return null;
        }
        ServerConnection connection = (ServerConnection)serverConnection.get();
        return connection.getServerInfo().getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.handle.getUniqueId();
    }

    @Override
    public void connect(AdaptedServer server) {
        Debug.info("Attempting to send " + this.getName() + " to " + server.getName());
        this.handle.createConnectionRequest((RegisteredServer)server.getHandle()).connect().thenAcceptAsync(result -> {
            if (!result.isSuccessful()) {
                QueueMain main = QueueMain.getInstance();
                Component reason = result.getReasonComponent().orElse(null);
                if (reason == null) {
                    switch (result.getStatus()) {
                        case SUCCESS: {
                            reason = Component.text("Success");
                            break;
                        }
                        case ALREADY_CONNECTED: {
                            reason = Component.text("Already connected");
                            break;
                        }
                        case CONNECTION_IN_PROGRESS: {
                            reason = Component.text("Already connecting");
                            break;
                        }
                        case CONNECTION_CANCELLED: {
                            reason = Component.text("Connection canceled");
                            break;
                        }
                        case SERVER_DISCONNECTED: {
                            reason = Component.text("Connection failed with unknown reason");
                        }
                    }
                }
                if (main.getConfig().getBoolean("velocity-kick-message")) {
                    this.handle.sendMessage(main.getMessages().getComponent("velocity-kick-message", "SERVER:" + server.getName(), "REASON:" + PlainTextComponentSerializer.plainText().serialize(reason)));
                }
                main.getEventHandler().onServerKick(this, server, reason, false);
            }
        });
    }

    @Override
    public int getProtocolVersion() {
        if (this.viaAvailable) {
            return Via.getAPI().getPlayerVersion(this.handle.getUniqueId());
        }
        return this.handle.getProtocolVersion().getProtocol();
    }

    @Override
    public String getName() {
        return this.handle.getUsername();
    }

    @Override
    public void kick(Component reason) {
        this.handle.disconnect(reason);
    }

    @Override
    public List<String> getPermissions() {
        throw new IllegalStateException("AdaptedPlayer#getPermissions cannot be used on velocity");
    }

    public Player getHandle() {
        return this.handle;
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VelocityPlayer that = (VelocityPlayer)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return Objects.hash(this.handle);
    }
}

