/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord.players;

import com.viaversion.viaversion.api.Via;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.platforms.bungeecord.BungeeQueue;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServer;

public class BungeePlayer
implements AdaptedPlayer,
Audience {
    final ProxiedPlayer handle;
    private final boolean viaAvailable;

    @Override
    public void sendActionBar(@NotNull ComponentLike message) {
        this.getAudience().sendActionBar(message);
    }

    @Override
    public void showTitle(@NotNull Title title) {
        this.getAudience().showTitle(title);
    }

    @Override
    public void clearTitle() {
        this.getAudience().clearTitle();
    }

    @Override
    public void resetTitle() {
        this.getAudience().resetTitle();
    }

    @Override
    public void showBossBar(@NotNull BossBar bar) {
        this.getAudience().showBossBar(bar);
    }

    @Override
    public void hideBossBar(@NotNull BossBar bar) {
        this.getAudience().hideBossBar(bar);
    }

    @Override
    public void playSound(@NotNull Sound sound) {
        this.getAudience().playSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, double x, double y, double z) {
        this.getAudience().playSound(sound, x, y, z);
    }

    @Override
    public void stopSound(@NotNull Sound sound) {
        this.getAudience().stopSound(sound);
    }

    @Override
    public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter emitter) {
        this.getAudience().playSound(sound, emitter);
    }

    @Override
    public void stopSound(@NotNull SoundStop stop) {
        this.getAudience().stopSound(stop);
    }

    public BungeePlayer(ProxiedPlayer player) {
        this.handle = player;
        this.viaAvailable = BungeePlayer.isClassAvailable("com.viaversion.viaversion.api.Via");
    }

    @Override
    public boolean isConnected() {
        return this.handle.isConnected();
    }

    @Override
    public void sendMessage(@NotNull Component message) {
        if (PlainTextComponentSerializer.plainText().serialize(message).isEmpty()) {
            return;
        }
        this.getAudience().sendMessage(message);
    }

    @Override
    public void sendActionBar(@NotNull Component message) {
        if (PlainTextComponentSerializer.plainText().serialize(message).isEmpty()) {
            return;
        }
        this.getAudience().sendActionBar(message);
    }

    @Override
    public void sendMessage(String message) {
        if (message.isEmpty()) {
            return;
        }
        this.getAudience().sendMessage(Component.text(message));
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.handle.hasPermission(permission);
    }

    @Override
    public String getServerName() {
        return this.handle.getServer().getInfo().getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.handle.getUniqueId();
    }

    @Override
    public void connect(AdaptedServer server) {
        Debug.info("Attempting to send " + this.getName() + " to " + server.getName());
        this.handle.connect(((BungeeServer)server).getHandle());
    }

    @Override
    public int getProtocolVersion() {
        if (this.viaAvailable) {
            return Via.getAPI().getPlayerVersion(this.handle.getUniqueId());
        }
        return this.handle.getPendingConnection().getVersion();
    }

    @Override
    public String getName() {
        return this.handle.getName();
    }

    @Override
    public void kick(Component reason) {
        this.handle.disconnect(BungeeComponentSerializer.get().serialize(reason));
    }

    @Override
    public List<String> getPermissions() {
        return new ArrayList<String>(this.handle.getPermissions());
    }

    public ProxiedPlayer getHandle() {
        return this.handle;
    }

    private Audience getAudience() {
        return BungeeQueue.adventure().player(this.handle);
    }

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BungeePlayer that = (BungeePlayer)o;
        return this.handle.equals(that.handle);
    }

    public int hashCode() {
        return Objects.hash(this.handle);
    }
}

