/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.platforms.bungeecord;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import us.ajg0702.queue.api.PlatformMethods;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.api.util.QueueLogger;
import us.ajg0702.queue.commands.commands.PlayerSender;
import us.ajg0702.queue.platforms.bungeecord.BungeeQueue;
import us.ajg0702.queue.platforms.bungeecord.players.BungeePlayer;
import us.ajg0702.queue.platforms.bungeecord.server.BungeeServer;

public class BungeeMethods
implements PlatformMethods {
    final ProxyServer proxyServer;
    final QueueLogger logger;
    final BungeeQueue plugin;
    List<BungeeServer> serverList = new ArrayList<BungeeServer>();

    public BungeeMethods(BungeeQueue plugin, ProxyServer proxyServer, QueueLogger logger) {
        this.proxyServer = proxyServer;
        this.logger = logger;
        this.plugin = plugin;
    }

    @Override
    public void sendPluginMessage(AdaptedPlayer player, String channel, String ... data) {
        Collection networkPlayers = ProxyServer.getInstance().getPlayers();
        if (networkPlayers != null && !networkPlayers.isEmpty()) {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF(channel);
            out.writeUTF(player.getName());
            for (String s : data) {
                out.writeUTF(s);
            }
            ProxiedPlayer proxiedPlayer = ((BungeePlayer)player).getHandle();
            if (proxiedPlayer == null) {
                return;
            }
            Server server = proxiedPlayer.getServer();
            if (server == null) {
                return;
            }
            server.sendData("ajqueue:tospigot", out.toByteArray());
        }
    }

    @Override
    public AdaptedPlayer senderToPlayer(ICommandSender sender) {
        if (sender instanceof PlayerSender) {
            return ((PlayerSender)sender).getHandle();
        }
        return new BungeePlayer((ProxiedPlayer)sender.getHandle());
    }

    @Override
    public String getPluginVersion() {
        return this.plugin.getDescription().getVersion();
    }

    @Override
    public List<AdaptedPlayer> getOnlinePlayers() {
        ArrayList<AdaptedPlayer> players = new ArrayList<AdaptedPlayer>();
        this.proxyServer.getPlayers().forEach(pp -> players.add(new BungeePlayer((ProxiedPlayer)pp)));
        return players;
    }

    @Override
    public List<String> getPlayerNames(boolean lowercase) {
        ArrayList<String> names = new ArrayList<String>();
        this.proxyServer.getPlayers().forEach(player -> names.add(lowercase ? player.getName().toLowerCase(Locale.ROOT) : player.getName()));
        return names;
    }

    @Override
    public AdaptedPlayer getPlayer(String name) {
        ProxiedPlayer player = this.proxyServer.getPlayer(name);
        if (player == null) {
            return null;
        }
        return new BungeePlayer(player);
    }

    @Override
    public AdaptedPlayer getPlayer(UUID uuid) {
        ProxiedPlayer player = this.proxyServer.getPlayer(uuid);
        if (player == null) {
            return null;
        }
        return new BungeePlayer(player);
    }

    @Override
    public List<String> getServerNames() {
        return new ArrayList<String>(this.proxyServer.getServers().keySet());
    }

    @Override
    public String getImplementationName() {
        return "BungeeCord";
    }

    @Override
    public List<IBaseCommand> getCommands() {
        return this.plugin.commands;
    }

    @Override
    public boolean hasPlugin(String pluginName) {
        return this.proxyServer.getPluginManager().getPlugin(pluginName) != null;
    }

    @Override
    public AdaptedServer getServer(String name) {
        List<? extends AdaptedServer> servers = this.getServers();
        for (AdaptedServer adaptedServer : servers) {
            if (!adaptedServer.getName().equals(name)) continue;
            return adaptedServer;
        }
        return null;
    }

    @Override
    public List<? extends AdaptedServer> getServers() {
        boolean found;
        for (ServerInfo serverInfo : this.proxyServer.getServers().values()) {
            found = false;
            for (BungeeServer sv : new ArrayList<BungeeServer>(this.serverList)) {
                if (!sv.getHandle().equals(serverInfo)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.serverList.add(new BungeeServer(serverInfo));
        }
        for (BungeeServer sv : new ArrayList<BungeeServer>(this.serverList)) {
            found = false;
            for (ServerInfo serverInfo : this.proxyServer.getServers().values()) {
                if (!sv.getHandle().equals(serverInfo)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.serverList.remove(sv);
        }
        return this.serverList;
    }

    @Override
    public String getProtocolName(int protocol) {
        return protocol + "";
    }
}

