/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.libs.utils.bungee;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class BungeeMessages {
    static BungeeMessages INSTANCE = null;
    Plugin pl;
    ConfigurationProvider cv = ConfigurationProvider.getProvider(YamlConfiguration.class);
    Configuration msgs;
    File msgFile;
    LinkedHashMap<String, String> defaultValues;

    public static BungeeMessages getInstance() {
        return INSTANCE;
    }

    public static BungeeMessages getInstance(Plugin pl, LinkedHashMap<String, String> defaultValues) {
        if (INSTANCE == null) {
            INSTANCE = new BungeeMessages(pl, defaultValues);
        }
        return INSTANCE;
    }

    private BungeeMessages(Plugin pl, LinkedHashMap<String, String> defaultValues) {
        this.pl = pl;
        this.defaultValues = defaultValues;
        this.loadMessagesFile(defaultValues);
    }

    private void loadMessagesFile(LinkedHashMap<String, String> d) {
        this.msgFile = new File(this.pl.getDataFolder(), "messages.yml");
        if (!this.msgFile.exists()) {
            try {
                this.pl.getDataFolder().mkdirs();
                this.msgFile.createNewFile();
            }
            catch (IOException e) {
                this.pl.getLogger().severe("Unable to create messages file:");
                e.printStackTrace();
            }
        }
        try {
            this.msgs = this.cv.load(this.msgFile);
        }
        catch (IOException e) {
            this.pl.getLogger().severe("Unable to load messages file:");
            e.printStackTrace();
            return;
        }
        for (String k : d.keySet()) {
            if (this.msgs.contains(k)) continue;
            this.msgs.set(k, (Object)d.get(k));
        }
        try {
            this.cv.save(this.msgs, this.msgFile);
        }
        catch (IOException e) {
            this.pl.getLogger().severe("Unable to save messages file:");
            e.printStackTrace();
        }
    }

    @Deprecated
    public String get(String key) {
        String msg = (String)this.msgs.get(key, (Object)("&cMessage '" + key + "' does not exist!"));
        msg = this.color(msg);
        return msg;
    }

    public String getString(String key, String ... placeholders) {
        String msg = (String)this.msgs.get(key, (Object)("&cMessage '" + key + "' does not exist!"));
        msg = this.color(msg);
        for (String sr : placeholders) {
            String placeholder = sr.split(":")[0];
            String value = sr.replaceFirst(Matcher.quoteReplacement(placeholder + ":"), "");
            msg = msg.replaceAll("\\{" + Matcher.quoteReplacement(placeholder) + "}", value);
        }
        return msg;
    }

    public BaseComponent[] getBC(String key, String ... placeholders) {
        return this.getBC(this.getComponent(key, placeholders));
    }

    public BaseComponent[] getBC(Component component) {
        return BungeeComponentSerializer.get().serialize(component);
    }

    public Component getComponent(String key, String ... placeholders) {
        String m = this.getString(key, placeholders);
        return MiniMessage.miniMessage().deserialize(m);
    }

    public String color(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg).replaceAll(Matcher.quoteReplacement("\\n"), "\n");
    }

    public void reload() {
        this.loadMessagesFile(this.defaultValues);
    }
}

