/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common.queues.balancers;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.queues.Balancer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.common.QueueMain;

public class MinigameBalancer
implements Balancer {
    private final QueueServer server;
    private final QueueMain main;

    public MinigameBalancer(QueueServer server, QueueMain main) {
        this.server = server;
        this.main = main;
    }

    @Override
    public AdaptedServer getIdealServer(AdaptedPlayer player) {
        ImmutableList<AdaptedServer> servers = this.server.getServers();
        if (servers.size() == 1) {
            return (AdaptedServer)servers.get(0);
        }
        ArrayList<AdaptedServer> svs = new ArrayList<AdaptedServer>((Collection<AdaptedServer>)servers);
        svs.sort(Comparator.comparingInt(o -> ((AdaptedServer)o).getPlayerCount()).reversed());
        for (AdaptedServer si : svs) {
            int max;
            int online;
            if (!si.isOnline() || (online = si.getPlayerCount()) >= (max = si.getMaxPlayers()) || !si.isJoinable(player)) continue;
            return si;
        }
        return (AdaptedServer)svs.get(svs.size() - 1);
    }
}

