/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import us.ajg0702.queue.api.QueueManager;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.premium.Logic;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.commands.manage.PauseQueueServer;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.common.queues.QueueServerImpl;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.libs.utils.common.Messages;
import us.ajg0702.queue.libs.utils.common.TimeUtils;

public class QueueManagerImpl
implements QueueManager {
    private CopyOnWriteArrayList<QueueServer> servers = new CopyOnWriteArrayList();
    private final QueueMain main;
    private final Messages msgs;
    protected final Map<AdaptedPlayer, Long> pausedAntiSpam = new ConcurrentHashMap<AdaptedPlayer, Long>();
    final ConcurrentHashMap<AdaptedPlayer, Long> sendingNowAntiSpam = new ConcurrentHashMap();
    final Map<QueuePlayer, Integer> sendingAttempts = new WeakHashMap<QueuePlayer, Integer>();

    public QueueManagerImpl(QueueMain main) {
        this.main = main;
        this.msgs = main.getMessages();
        int delay = main.getConfig().getBoolean("wait-to-load-servers") ? main.getConfig().getInt("wait-to-load-servers-delay") : 0;
        main.getTaskManager().runLater(this::reloadServers, delay, TimeUnit.MILLISECONDS);
    }

    public List<QueueServer> buildServers() {
        ArrayList<QueueServer> result = new ArrayList<QueueServer>();
        List<? extends AdaptedServer> servers = this.main.getPlatformMethods().getServers();
        for (AdaptedServer adaptedServer : servers) {
            ImmutableList<QueuePlayer> previousPlayers;
            QueueServer previousServer = this.findServer(adaptedServer.getName());
            ImmutableList<QueuePlayer> immutableList = previousPlayers = previousServer == null ? new ImmutableList<QueuePlayer>() : previousServer.getQueue();
            if (previousPlayers.size() > 0) {
                this.main.getLogger().info("Adding " + previousPlayers.size() + " players back to the queue for " + adaptedServer.getName());
            }
            QueueServerImpl queueServer = new QueueServerImpl(adaptedServer.getName(), this.main, adaptedServer, (List<QueuePlayer>)previousPlayers);
            if (previousServer != null) {
                queueServer.setPaused(previousServer.isPaused());
                queueServer.setLastSentTime(previousServer.getLastSentTime());
            }
            result.add(queueServer);
        }
        List<String> groupsRaw = this.main.getConfig().getStringList("server-groups");
        for (String groupRaw : groupsRaw) {
            ImmutableList<QueuePlayer> previousPlayers;
            if (groupRaw.isEmpty()) {
                this.main.getLogger().warning("Empty group string! If you dont want server groups, set server-groups like this: server-groups: []");
                continue;
            }
            if (!groupRaw.contains(":")) {
                this.main.getLogger().warning("Incorrect formatting! Each server group needs to have a name and a list of servers seperated by a colon (:).");
                continue;
            }
            String groupName = groupRaw.split(":")[0];
            String[] serversraw = groupRaw.split(":")[1].split(",");
            if (this.findServer(groupName, result) != null) {
                this.main.getLogger().warning("The name of a group ('" + groupName + "') cannot be the same as the name of a server!");
                continue;
            }
            ArrayList<AdaptedServer> groupServers = new ArrayList<AdaptedServer>();
            for (String serverraw : serversraw) {
                QueueServer found = this.findServer(serverraw, result);
                if (found == null) {
                    this.main.getLogger().warning("Could not find server named '" + serverraw + "' in servergroup '" + groupName + "'!");
                    continue;
                }
                if (found.isGroup()) continue;
                groupServers.add((AdaptedServer)found.getServers().get(0));
            }
            if (groupServers.size() == 0) {
                this.main.getLogger().warning("Server group '" + groupName + "' has no servers! Ignoring it.");
                continue;
            }
            QueueServer previousServer = this.main.getQueueManager().findServer(groupName);
            ImmutableList<QueuePlayer> immutableList = previousPlayers = previousServer == null ? new ImmutableList<QueuePlayer>() : previousServer.getQueue();
            if (previousPlayers.size() > 0) {
                this.main.getLogger().info("Adding " + previousPlayers.size() + " players back to the queue for " + groupName);
            }
            result.add(new QueueServerImpl(groupName, this.main, (List<AdaptedServer>)groupServers, (List<QueuePlayer>)previousPlayers));
        }
        List<String> list = this.main.getConfig().getStringList("supported-protocols");
        for (String supportedProtocolsString : list) {
            String[] parts = supportedProtocolsString.split(":");
            if (parts.length < 2) {
                this.main.getLogger().warn("Invalid supported protocols entry! Must have a colon to seperate the server(s) and the protocols");
                continue;
            }
            String serversRaw = parts[0];
            String protocolsRaw = parts[1];
            ArrayList<Integer> protocols = new ArrayList<Integer>();
            for (String protocolString : protocolsRaw.split(",")) {
                try {
                    protocols.add(Integer.valueOf(protocolString));
                }
                catch (NumberFormatException e) {
                    this.main.getLogger().info("The protocol " + protocolString + " is not a valid number!");
                }
            }
            for (String serverName : serversRaw.split(",")) {
                boolean found = false;
                for (QueueServer server : result) {
                    if (!serverName.equalsIgnoreCase(server.getName())) continue;
                    server.setSupportedProtocols(protocols);
                    found = true;
                    Debug.info("Applied " + protocols + " to " + server.getName() + "(" + serverName + ")");
                    break;
                }
                if (found) continue;
                Debug.info("Found no server named " + serverName);
            }
        }
        return result;
    }

    @Override
    public boolean addToQueue(AdaptedPlayer player, QueueServer server) {
        boolean timeGood;
        QueuePlayer queuePlayer;
        if (player == null || server == null) {
            Debug.info("addToQueue method called, but something is null");
            return false;
        }
        if (!player.isConnected()) {
            Debug.info("addToQueue method called, but player is not connected");
            return false;
        }
        if (player.getServerName() == null) {
            this.main.getLogger().warning("Tried to queue " + player.getName() + " when they aren't connected!");
            return false;
        }
        Debug.info("addToQueue method called for " + player.getName() + " to " + server.getName());
        int playerVersion = player.getProtocolVersion();
        List<Integer> supportedProtocols = server.getSupportedProtocols();
        if (!supportedProtocols.contains(playerVersion) && supportedProtocols.size() > 0) {
            StringBuilder versions = new StringBuilder();
            for (int protocol : supportedProtocols) {
                versions.append(this.main.getProtocolNameManager().getProtocolName(protocol));
                if (supportedProtocols.indexOf(protocol) == supportedProtocols.size() - 2) {
                    versions.append(this.msgs.getString("errors.wrong-version.or", new String[0]));
                    continue;
                }
                if (supportedProtocols.indexOf(protocol) == supportedProtocols.size() - 1) continue;
                versions.append(this.msgs.getString("errors.wrong-version.comma", new String[0]));
            }
            player.sendMessage(this.msgs.getComponent("errors.wrong-version.base", "VERSIONS:" + versions, "SERVER:" + server.getAlias()));
            return false;
        }
        boolean enableBypassPaused = this.main.getConfig().getBoolean("enable-bypasspaused-permission");
        if (server.isPaused() && this.main.getConfig().getBoolean("prevent-joining-paused") && (!enableBypassPaused || !player.hasPermission("ajqueue.bypasspaused"))) {
            player.sendMessage(this.msgs.getComponent("errors.cant-join-paused", "SERVER:" + server.getAlias()));
            return false;
        }
        ArrayList<AdaptedServer> notInServers = new ArrayList<AdaptedServer>((Collection<AdaptedServer>)server.getServers());
        notInServers.removeIf(adaptedServer -> !adaptedServer.getName().equals(player.getServerName()));
        if (notInServers.size() > 0) {
            player.sendMessage(this.msgs.getComponent("errors.already-connected", "SERVER:" + server.getAlias()));
            return false;
        }
        ImmutableList<QueueServer> beforeQueues = this.getPlayerQueues(player);
        if (beforeQueues.size() > 0) {
            if (beforeQueues.contains((Object)server)) {
                player.sendMessage(this.msgs.getComponent("errors.already-queued", new String[0]));
                return false;
            }
            if (!this.main.getConfig().getBoolean("allow-multiple-queues")) {
                player.sendMessage(this.msgs.getComponent("status.left-last-queue", "SERVER:" + server.getAlias()));
                for (QueueServer ser : beforeQueues) {
                    ser.removePlayer(player);
                }
            }
        }
        ImmutableList<QueuePlayer> list = server.getQueue();
        AdaptedServer ideal = server.getIdealServer(player);
        if (this.main.isPremium()) {
            queuePlayer = this.main.getLogic().priorityLogic(server, player, ideal);
        } else {
            int priority = player.hasPermission("ajqueue.priority") || player.hasPermission("ajqueue.serverpriority." + server.getName()) ? 1 : 0;
            priority = Math.max(priority, Logic.getUnJoinablePriorities(server, ideal, player) > 0 ? 1 : 0);
            int maxOfflineTime = player.hasPermission("ajqueue.stayqueued") ? 60 : 0;
            queuePlayer = new QueuePlayerImpl(player, server, priority, maxOfflineTime);
            if (priority == 1 && server.getQueue().size() > 0) {
                int i = 0;
                for (QueuePlayer ply : list) {
                    if (!ply.hasPriority()) {
                        server.addPlayer(queuePlayer, i);
                        break;
                    }
                    ++i;
                }
            }
            if (!list.contains((Object)queuePlayer)) {
                server.addPlayer(queuePlayer);
            }
        }
        list = server.getQueue();
        int pos = queuePlayer.getPosition();
        int len = list.size();
        boolean sendInstant = server.isJoinable(player);
        boolean sendInstantp = list.size() <= 1 && server.isJoinable(player);
        boolean bl = timeGood = !this.main.getConfig().getBoolean("check-last-player-sent-time") || (double)server.getLastSentTime() > Math.floor(this.main.getTimeBetweenPlayers() * 1000.0);
        if (this.main.getConfig().getStringList("send-instantly").contains(server.getName()) || sendInstant && sendInstantp && timeGood) {
            this.sendPlayers(server);
            if (!this.msgs.isEmpty("status.now-in-empty-queue")) {
                player.sendMessage(this.msgs.getComponent("status.now-in-empty-queue", "POS:" + pos, "LEN:" + len, "SERVER:" + server.getAlias()));
            }
        } else {
            player.sendMessage(this.msgs.getComponent("status.now-in-queue", "POS:" + pos, "LEN:" + len, "SERVER:" + server.getAlias(), "SERVERNAME:" + server.getName()));
            if (this.main.getConfig().getBoolean("enable-priority-messages")) {
                for (String rawPriorityMessage : this.main.getConfig().getStringList("priority-messages")) {
                    String[] parts = rawPriorityMessage.split(":");
                    if (parts.length != 2) continue;
                    String level = parts[0];
                    String messageRaw = parts[1];
                    if ((!level.equals("*") || queuePlayer.getPriority() <= 0) && !level.equals(queuePlayer.getPriority() + "")) continue;
                    player.sendMessage(this.main.getMessages().toComponent(messageRaw.replaceAll("\\{PRIORITY}", queuePlayer.getPriority() + "")));
                }
            }
        }
        if (!server.isJoinable(player)) {
            this.sendMessage(queuePlayer);
        }
        this.main.getPlatformMethods().sendPluginMessage(player, "position", pos + "");
        this.main.getPlatformMethods().sendPluginMessage(player, "positionof", len + "");
        this.main.getPlatformMethods().sendPluginMessage(player, "queuename", server.getAlias());
        this.main.getPlatformMethods().sendPluginMessage(player, "inqueue", "true");
        this.main.getPlatformMethods().sendPluginMessage(player, "inqueueevent", "true");
        return true;
    }

    @Override
    public boolean addToQueue(AdaptedPlayer player, String serverName) {
        QueueServer server = this.findServer(serverName);
        if (server == null) {
            player.sendMessage(this.msgs.getComponent("errors.server-not-exist", "SERVER:" + serverName));
            return false;
        }
        return this.addToQueue(player, server);
    }

    @Override
    public ImmutableList<QueueServer> getServers() {
        return ImmutableList.copyOf(this.servers);
    }

    @Override
    public ImmutableList<String> getServerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (QueueServer s : this.servers) {
            names.add(s.getName());
        }
        return ImmutableList.copyOf(names);
    }

    @Override
    public QueueServer getSingleServer(AdaptedPlayer player) {
        ImmutableList<QueuePlayer> queued = this.findPlayerInQueues(player);
        if (queued.size() <= 0) {
            return null;
        }
        QueueServer selected = ((QueuePlayer)queued.get(0)).getQueueServer();
        if (this.main.getConfig().getString("multi-server-queue-pick").equalsIgnoreCase("last")) {
            selected = ((QueuePlayer)queued.get(queued.size() - 1)).getQueueServer();
        }
        return selected;
    }

    @Override
    public String getQueuedName(AdaptedPlayer player) {
        QueueServer server = this.getSingleServer(player);
        if (server == null) {
            return this.main.getMessages().getString("placeholders.queued.none", new String[0]);
        }
        return server.getName();
    }

    @Override
    public void reloadServers() {
        if (this.main.getConfig() == null) {
            this.main.getLogger().severe("[MAN] Config is null");
        }
        this.servers = new CopyOnWriteArrayList<QueueServer>(this.buildServers());
    }

    @Override
    public void sendActionBars() {
        if (!this.main.getConfig().getBoolean("send-actionbar")) {
            return;
        }
        for (QueueServer server : this.servers) {
            for (QueuePlayer queuePlayer : server.getQueue()) {
                int pos = queuePlayer.getPosition();
                if (pos == 0) {
                    server.removePlayer(queuePlayer);
                    continue;
                }
                AdaptedPlayer player = queuePlayer.getPlayer();
                if (player == null) continue;
                String status = server.getStatusString(player);
                QueueServer singleServer = this.getSingleServer(player);
                if (singleServer == null || !singleServer.equals(server)) continue;
                if (!server.isJoinable(player)) {
                    player.sendActionBar(this.msgs.getComponent("spigot.actionbar.offline", "POS:" + pos, "LEN:" + server.getQueue().size(), "SERVER:" + server.getAlias(), "STATUS:" + status));
                    continue;
                }
                int time = (int)Math.round((double)pos * this.main.getTimeBetweenPlayers());
                player.sendActionBar(this.msgs.getComponent("spigot.actionbar.online", "POS:" + pos, "LEN:" + server.getQueue().size(), "SERVER:" + server.getAlias(), "TIME:" + TimeUtils.timeString(time, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0]))));
            }
        }
    }

    @Override
    public void sendTitles() {
        if (!this.main.getConfig().getBoolean("send-title")) {
            return;
        }
        for (QueueServer server : this.servers) {
            for (QueuePlayer queuePlayer : server.getQueue()) {
                QueueServer singleServer;
                int pos = queuePlayer.getPosition();
                if (pos == 0) {
                    server.removePlayer(queuePlayer);
                    continue;
                }
                AdaptedPlayer player = queuePlayer.getPlayer();
                if (player == null || (singleServer = this.getSingleServer(player)) == null || !singleServer.equals(server)) continue;
                String status = Messages.color(this.main.getMessages().getRawString("placeholders.status." + server.getStatus(player), new String[0]));
                int time = (int)Math.round((double)pos * this.main.getTimeBetweenPlayers());
                Component titleMessage = this.msgs.getComponent("title.title", "POS:" + pos, "LEN:" + server.getQueue().size(), "SERVER:" + server.getAlias(), "STATUS:" + status, "TIME:" + TimeUtils.timeString(time, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0])));
                Component subTitleMessage = this.msgs.getComponent("title.subtitle", "POS:" + pos, "LEN:" + server.getQueue().size(), "SERVER:" + server.getAlias(), "STATUS:" + status, "TIME:" + TimeUtils.timeString(time, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0])));
                Title title = Title.title(titleMessage, subTitleMessage, Title.Times.of(Duration.ZERO, Duration.ofSeconds(2L), Duration.ZERO));
                player.showTitle(title);
            }
        }
    }

    @Override
    public void sendQueueEvents() {
        if (this.main.getConfig().getBoolean("force-queue-server-target")) {
            List<String> svs = this.main.getConfig().getStringList("queue-servers");
            for (String s : svs) {
                if (!s.contains(":")) continue;
                String[] parts = s.split(":");
                String fromName = parts[0];
                String toName = parts[1];
                AdaptedServer from = this.main.getPlatformMethods().getServer(fromName);
                QueueServer to = this.findServer(toName);
                if (from == null || to == null) continue;
                from.getPlayers().forEach(player -> {
                    if (PauseQueueServer.pausedPlayers.contains(player)) {
                        long lastReminder = this.pausedAntiSpam.getOrDefault(player, 0L);
                        if ((double)(System.currentTimeMillis() - lastReminder) > 60000.0) {
                            player.sendMessage(this.main.getMessages().getComponent("commands.pausequeueserver.reminder", new String[0]));
                            this.pausedAntiSpam.put((AdaptedPlayer)player, System.currentTimeMillis());
                        }
                        return;
                    }
                    if (!this.getPlayerQueues((AdaptedPlayer)player).contains((Object)to)) {
                        this.addToQueue((AdaptedPlayer)player, to);
                    }
                });
            }
        }
        for (QueueServer s : this.servers) {
            for (QueuePlayer queuePlayer : s.getQueue()) {
                AdaptedPlayer player2 = queuePlayer.getPlayer();
                if (player2 == null || !player2.isConnected() || player2.getServerName() == null) continue;
                this.main.getPlatformMethods().sendPluginMessage(player2, "inqueueevent", "true");
            }
        }
    }

    @Override
    public void sendMessages() {
        try {
            for (QueueServer server : this.servers) {
                for (QueuePlayer queuePlayer : server.getQueue()) {
                    this.sendMessage(queuePlayer);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendMessage(QueuePlayer queuePlayer) {
        AdaptedPlayer player = queuePlayer.getPlayer();
        if (player == null || !player.isConnected()) {
            return;
        }
        QueueServer server = queuePlayer.getQueueServer();
        int pos = queuePlayer.getPosition();
        int len = server.getQueue().size();
        if (!server.isJoinable(player)) {
            String status = server.getStatusString(player);
            if (this.msgs.getString("status.offline.base", new String[0]).isEmpty()) {
                return;
            }
            player.sendMessage(this.msgs.getComponent("status.offline.base", "STATUS:" + status, "POS:" + pos, "LEN:" + len, "SERVER:" + server.getAlias()));
        } else {
            if (this.msgs.getString("status.online.base", new String[0]).isEmpty()) {
                return;
            }
            int time = (int)Math.round((double)pos * this.main.getTimeBetweenPlayers());
            player.sendMessage(this.msgs.getComponent("status.online.base", "TIME:" + TimeUtils.timeString(time, this.msgs.getString("format.time.mins", new String[0]), this.msgs.getString("format.time.secs", new String[0])), "POS:" + pos, "LEN:" + len, "SERVER:" + server.getAlias()));
        }
    }

    @Override
    public void updateServers() {
        ExecutorService pool = this.main.getTaskManager().getServersUpdateExecutor();
        if (pool instanceof ThreadPoolExecutor && this.main.getConfig().getBoolean("pinger-debug")) {
            this.main.getLogger().info("[pinger] Server update thread pool has " + ((ThreadPoolExecutor)pool).getActiveCount() + " threads");
        }
        try {
            for (AdaptedServer adaptedServer : this.main.getPlatformMethods().getServers()) {
                pool.submit(() -> server.ping(this.main.getConfig().getBoolean("pinger-debug"), this.main.getLogger()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public QueueServer findServer(String name) {
        return this.findServer(name, this.servers);
    }

    public QueueServer findServer(String name, List<QueueServer> servers) {
        for (QueueServer server : servers) {
            if (server == null || !server.getName().equalsIgnoreCase(name)) continue;
            return server;
        }
        return null;
    }

    @Override
    public void sendPlayers() {
        this.sendPlayers(null);
    }

    @Override
    public void sendPlayers(QueueServer queueServer) {
        List<QueueServer> sendingServers = queueServer == null ? new ArrayList<QueueServer>(this.servers) : Collections.singletonList(queueServer);
        for (QueueServer server : sendingServers) {
            int maxTries;
            AdaptedServer selected;
            for (QueuePlayer queuePlayer : server.getQueue()) {
                if (queuePlayer.getPlayer() != null || !this.main.getLogic().playerDisconnectedTooLong(queuePlayer)) continue;
                server.removePlayer(queuePlayer);
            }
            if (!server.isOnline() || server.getQueue().size() == 0) continue;
            Debug.info("should send instantly: " + !server.isGroup() + " && " + this.main.getConfig().getBoolean("send-all-when-back-online") + " && " + ((AdaptedServer)server.getServers().get(0)).justWentOnline());
            if (!server.isGroup() && this.main.getConfig().getBoolean("send-all-when-back-online") && ((AdaptedServer)server.getServers().get(0)).justWentOnline()) {
                for (QueuePlayer p : server.getQueue()) {
                    AdaptedPlayer player = p.getPlayer();
                    if (player == null) continue;
                    selected = server.getIdealServer(player);
                    if (selected == null) {
                        this.main.getLogger().severe("Could not find ideal server for server '" + server.getName() + "'!");
                        continue;
                    }
                    if (selected.isFull() && !selected.canJoinFull(p.getPlayer())) continue;
                    player.sendMessage(this.msgs.getComponent("status.sending-now", "SERVER:" + server.getAlias()));
                    player.connect(selected);
                }
                continue;
            }
            QueuePlayer nextQueuePlayer = (QueuePlayer)server.getQueue().get(0);
            AdaptedPlayer nextPlayer = nextQueuePlayer.getPlayer();
            int i = 0;
            while ((nextPlayer == null || server.getServerNames().contains((Object)nextPlayer.getServerName())) && i < server.getQueue().size()) {
                if (nextPlayer != null) {
                    server.removePlayer(nextQueuePlayer);
                    if (server.getQueue().size() > i) {
                        nextQueuePlayer = (QueuePlayer)server.getQueue().get(i);
                        nextPlayer = nextQueuePlayer.getPlayer();
                        continue;
                    }
                    nextPlayer = null;
                    break;
                }
                if (++i > server.getQueue().size() - 1) break;
                nextQueuePlayer = (QueuePlayer)server.getQueue().get(i);
                nextPlayer = nextQueuePlayer.getPlayer();
            }
            if (nextPlayer == null) continue;
            selected = server.getIdealServer(nextPlayer);
            if (selected == null) {
                this.main.getLogger().severe("Could not find ideal server for server/group '" + server.getName() + "'");
                continue;
            }
            if (selected.isWhitelisted() && !selected.getWhitelistedPlayers().contains(nextPlayer.getUniqueId()) || !server.canAccess(nextPlayer) || selected.isFull() && !selected.canJoinFull(nextPlayer) || (!this.main.getConfig().getBoolean("enable-bypasspaused-permission") ? server.isPaused() : server.isPaused() && !nextPlayer.hasPermission("ajqueue.bypasspaused"))) continue;
            int tries = this.sendingAttempts.getOrDefault(nextQueuePlayer, 0);
            if (tries >= (maxTries = this.main.getConfig().getInt("max-tries").intValue()) && maxTries > 0) {
                server.removePlayer(nextQueuePlayer);
                this.sendingAttempts.remove(nextQueuePlayer);
                nextPlayer.sendMessage(this.msgs.getComponent("max-tries-reached", "SERVER:" + server.getAlias()));
                continue;
            }
            this.sendingAttempts.put(nextQueuePlayer, ++tries);
            if (!this.sendingNowAntiSpam.containsKey(nextPlayer)) {
                this.sendingNowAntiSpam.put(nextPlayer, 0L);
            }
            if (System.currentTimeMillis() - this.sendingNowAntiSpam.get(nextPlayer) >= 5000L) {
                nextPlayer.sendMessage(this.msgs.getComponent("status.sending-now", "SERVER:" + server.getAlias()));
                if (this.main.getConfig().getBoolean("send-title")) {
                    nextPlayer.showTitle(Title.title(this.main.getMessages().getComponent("title.sending-now.title", "SERVER:" + server.getAlias()), this.main.getMessages().getComponent("title.sending-now.subtitle", "SERVER:" + server.getAlias()), Title.Times.of(Duration.ZERO, Duration.ofSeconds(2L), Duration.ZERO)));
                }
                this.sendingNowAntiSpam.put(nextPlayer, System.currentTimeMillis());
            }
            server.setLastSentTime(System.currentTimeMillis());
            nextPlayer.connect(selected);
            selected.addPlayer();
            Debug.info(selected.getName() + " player count is now set to " + selected.getPlayerCount());
        }
    }

    @Override
    public ImmutableList<QueuePlayer> findPlayerInQueues(AdaptedPlayer p) {
        ArrayList<QueuePlayer> srs = new ArrayList<QueuePlayer>();
        for (QueueServer s : this.servers) {
            QueuePlayer player = s.findPlayer(p);
            if (player == null) continue;
            srs.add(player);
        }
        return ImmutableList.copyOf(srs);
    }

    @Override
    public ImmutableList<QueuePlayer> findPlayerInQueuesByName(String name) {
        ArrayList<QueuePlayer> srs = new ArrayList<QueuePlayer>();
        for (QueueServer s : this.servers) {
            QueuePlayer player = s.findPlayer(name);
            if (player == null) continue;
            srs.add(player);
        }
        return ImmutableList.copyOf(srs);
    }

    @Override
    public ImmutableList<QueueServer> getPlayerQueues(AdaptedPlayer p) {
        ArrayList<QueueServer> srs = new ArrayList<QueueServer>();
        for (QueueServer s : this.servers) {
            QueuePlayer player = s.findPlayer(p);
            if (player == null) continue;
            srs.add(s);
        }
        return ImmutableList.copyOf(srs);
    }

    @Override
    public void clear(AdaptedPlayer player) {
        for (AdaptedPlayer next : this.sendingNowAntiSpam.keySet()) {
            if (!next.equals(player)) continue;
            this.sendingNowAntiSpam.remove(next);
        }
    }

    @Override
    public Map<QueuePlayer, Integer> getSendingAttempts() {
        return this.sendingAttempts;
    }
}

