/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.common;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.queue.api.EventHandler;
import us.ajg0702.queue.api.commands.IBaseCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.commands.PlayerSender;
import us.ajg0702.queue.commands.commands.manage.PauseQueueServer;
import us.ajg0702.queue.commands.commands.queue.QueueCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.common.players.QueuePlayerImpl;
import us.ajg0702.queue.common.utils.Debug;
import us.ajg0702.queue.libs.utils.common.TimeUtils;

public class EventHandlerImpl
implements EventHandler {
    final QueueMain main;

    public EventHandlerImpl(QueueMain main) {
        this.main = main;
    }

    @Override
    public void handleMessage(AdaptedPlayer recievingPlayer, byte[] data) {
        block23: {
            IBaseCommand moveCommand = this.main.getPlatformMethods().getCommands().get(0);
            IBaseCommand leaveCommand = this.main.getPlatformMethods().getCommands().get(1);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            try {
                String srv;
                String pos;
                QueueServer server;
                String subchannel = in.readUTF();
                if (subchannel.equals("ack")) {
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "ack", "yes, im here");
                }
                if (subchannel.equals("queue")) {
                    String rawData = in.readUTF();
                    String[] args = new String[]{rawData};
                    moveCommand.execute(new PlayerSender(recievingPlayer), args);
                }
                if (subchannel.equals("massqueue")) {
                    String[] parts;
                    String inData = in.readUTF();
                    for (String part : parts = inData.split(",")) {
                        String[] pparts = part.split(":");
                        if (pparts.length < 2) continue;
                        String pname = pparts[0];
                        String pserver = pparts[1];
                        AdaptedPlayer p = this.main.getPlatformMethods().getPlayer(pname);
                        String[] args = new String[]{pserver};
                        moveCommand.execute(new PlayerSender(p), args);
                    }
                }
                if (subchannel.equals("queuename")) {
                    server = this.main.getQueueManager().getSingleServer(recievingPlayer);
                    String name = this.main.getMessages().getString("placeholders.position.none", new String[0]);
                    if (server != null) {
                        name = server.getAlias();
                    }
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "queuename", name);
                }
                if (subchannel.equals("position")) {
                    server = this.main.getQueueManager().getSingleServer(recievingPlayer);
                    pos = this.main.getMessages().getString("placeholders.position.none", new String[0]);
                    if (server != null) {
                        pos = server.getQueue().indexOf((Object)server.findPlayer(recievingPlayer)) + 1 + "";
                    }
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "position", pos);
                }
                if (subchannel.equals("positionof")) {
                    server = this.main.getQueueManager().getSingleServer(recievingPlayer);
                    pos = this.main.getMessages().getString("placeholders.position.none", new String[0]);
                    if (server != null) {
                        pos = server.getQueue().size() + "";
                    }
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "positionof", pos);
                }
                if (subchannel.equals("estimated_time")) {
                    String timeString;
                    server = this.main.getQueueManager().getSingleServer(recievingPlayer);
                    if (server != null) {
                        QueuePlayer queuePlayer = server.findPlayer(recievingPlayer);
                        int time = (int)Math.round((double)queuePlayer.getPosition() * this.main.getTimeBetweenPlayers());
                        timeString = TimeUtils.timeString(time, this.main.getMessages().getString("format.time.mins", new String[0]), this.main.getMessages().getString("format.time.secs", new String[0]));
                    } else {
                        timeString = this.main.getMessages().getString("placeholders.estimated_time.none", new String[0]);
                    }
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "estimated_time", timeString);
                }
                if (subchannel.equals("inqueue")) {
                    server = this.main.getQueueManager().getSingleServer(recievingPlayer);
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "inqueue", (server != null) + "");
                }
                if (subchannel.equals("queuedfor")) {
                    srv = in.readUTF();
                    QueueServer server2 = this.main.getQueueManager().findServer(srv);
                    if (server2 == null) {
                        return;
                    }
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "queuedfor", srv, server2.getQueue().size() + "");
                }
                if (subchannel.equals("status")) {
                    srv = in.readUTF();
                    QueueServer server3 = this.main.getQueueManager().findServer(srv);
                    if (server3 == null) {
                        return;
                    }
                    if (!recievingPlayer.isConnected() || recievingPlayer.getServerName() == null) {
                        return;
                    }
                    this.main.getPlatformMethods().sendPluginMessage(recievingPlayer, "status", srv, this.main.getMessages().getRawString("placeholders.status." + server3.getStatus(recievingPlayer), new String[0]));
                }
                if (!subchannel.equals("leavequeue")) break block23;
                String[] args = new String[1];
                try {
                    args[0] = in.readUTF();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                leaveCommand.execute(new PlayerSender(recievingPlayer), args);
            }
            catch (IOException e1) {
                this.main.getLogger().warning("An error occured while reading data from spigot side:");
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void onPlayerJoin(AdaptedPlayer player) {
        if (player.hasPermission("ajqueue.manage.update")) {
            this.main.getTaskManager().runLater(() -> {
                if (this.main.getUpdater().isUpdateAvailable() && !this.main.getUpdater().isAlreadyDownloaded()) {
                    player.sendMessage(this.main.getMessages().getComponent("updater.update-available", new String[0]));
                }
            }, 2L, TimeUnit.SECONDS);
        }
        ImmutableList<QueuePlayer> queues = this.main.getQueueManager().findPlayerInQueues(player);
        for (QueuePlayer queuePlayer : queues) {
            queuePlayer.setPlayer(player);
        }
        if (queues.size() > 0) {
            this.main.getQueueManager().sendMessage(this.main.getQueueManager().getSingleServer(player).findPlayer(player));
        }
    }

    @Override
    public void onPlayerLeave(AdaptedPlayer player) {
        ImmutableList<QueuePlayer> queues = this.main.getQueueManager().findPlayerInQueues(player);
        for (QueuePlayer queuePlayer : queues) {
            ((QueuePlayerImpl)queuePlayer).setLeaveTime(System.currentTimeMillis());
            List<String> svs = this.main.getConfig().getStringList("queue-servers");
            for (String s : svs) {
                if (!s.contains(":")) continue;
                String[] parts = s.split(":");
                String from = parts[0];
                if (!queuePlayer.getQueueServer().getServerNames().contains((Object)from)) continue;
                queuePlayer.getQueueServer().removePlayer(queuePlayer);
            }
        }
        this.main.getQueueManager().clear(player);
    }

    @Override
    public void onPlayerJoinServer(AdaptedPlayer player) {
        ImmutableList<QueuePlayer> alreadyqueued = this.main.getQueueManager().findPlayerInQueues(player);
        for (QueuePlayer queuePlayer : alreadyqueued) {
            QueueServer server = queuePlayer.getQueueServer();
            int pos = queuePlayer.getPosition();
            if ((pos > 1 || !server.getServerNames().contains((Object)player.getServerName())) && !this.main.getConfig().getBoolean("remove-player-on-server-switch")) continue;
            server.removePlayer(player);
            server.setLastSentTime(System.currentTimeMillis());
            this.main.getQueueManager().getSendingAttempts().remove(queuePlayer);
        }
        if (this.main.getConfig().getBoolean("include-server-switch-in-cooldown")) {
            QueueCommand.cooldowns.put(player, System.currentTimeMillis());
        }
        if (!PauseQueueServer.pausedPlayers.contains(player)) {
            String serverName = player.getServerName();
            List<String> svs = this.main.getConfig().getStringList("queue-servers");
            for (String s : svs) {
                if (!s.contains(":")) continue;
                String[] parts = s.split(":");
                String from = parts[0];
                QueueServer to = this.main.getQueueManager().findServer(parts[1]);
                if (!from.equalsIgnoreCase(serverName) || to == null) continue;
                this.main.getQueueManager().addToQueue(player, to);
            }
        }
    }

    @Override
    public void onServerKick(AdaptedPlayer player, @NotNull AdaptedServer from, Component reason, boolean moving) {
        ImmutableList<QueueServer> queuedServers;
        if (!player.isConnected()) {
            return;
        }
        String plainReason = PlainTextComponentSerializer.plainText().serialize(reason);
        Debug.info(player.getName() + " kicked! Moving: " + moving + " from: " + from.getName() + " plainReason: " + plainReason);
        if (!moving && this.main.getConfig().getBoolean("send-fail-debug")) {
            this.main.getLogger().warning("Failed to send " + player.getName() + " to " + from.getName() + ". Kicked with reason: " + plainReason);
        }
        if (!(queuedServers = this.main.getQueueManager().getPlayerQueues(player)).contains((Object)this.main.getQueueManager().findServer(from.getName())) && this.main.getConfig().getBoolean("auto-add-to-queue-on-kick")) {
            List<String> reasons = this.main.getConfig().getStringList("auto-add-kick-reasons");
            boolean shouldqueue = false;
            for (String kickReason : reasons) {
                if (!plainReason.toLowerCase().contains(kickReason.toLowerCase())) continue;
                shouldqueue = true;
                break;
            }
            if (shouldqueue || reasons.isEmpty()) {
                this.main.getTaskManager().runLater(() -> {
                    if (!player.isConnected()) {
                        return;
                    }
                    String toName = from.getName();
                    player.sendMessage(this.main.getMessages().getComponent("auto-queued", "SERVER:" + toName));
                    this.main.getQueueManager().addToQueue(player, toName);
                }, (long)(this.main.getConfig().getDouble("auto-add-to-queue-on-kick-delay") * 1000.0), TimeUnit.MILLISECONDS);
                return;
            }
        }
        block1: for (QueueServer server : queuedServers) {
            QueuePlayer queuePlayer;
            if (!server.getServerNames().contains((Object)from.getName()) || (queuePlayer = server.findPlayer(player)).getPosition() != 1) continue;
            List<String> kickReasons = this.main.getConfig().getStringList("kick-reasons");
            boolean kickPlayer = this.main.getConfig().getBoolean("kick-kicked-players");
            if (kickPlayer) {
                Debug.info("Initially kicking player");
                List<String> svs = this.main.getConfig().getStringList("queue-servers");
                boolean found = false;
                for (String s : svs) {
                    if (!s.contains(":")) continue;
                    String[] parts = s.split(":");
                    String fromName = parts[0];
                    QueueServer toServer = this.main.getQueueManager().findServer(parts[1]);
                    if (toServer == null) continue;
                    Debug.info("fromName equals: " + fromName.equalsIgnoreCase(player.getServerName()) + " (" + fromName + " = " + player.getServerName() + ") toServer equals: " + toServer.equals(server));
                    if (!fromName.equalsIgnoreCase(player.getServerName()) || !toServer.equals(server)) continue;
                    found = true;
                }
                kickPlayer = found;
            }
            Debug.info("Kick player: " + kickPlayer);
            for (String kickReason : kickReasons) {
                if (!plainReason.toLowerCase().contains(kickReason.toLowerCase())) continue;
                server.removePlayer(queuePlayer);
                if (!kickPlayer) continue block1;
                player.kick(reason);
                continue block1;
            }
        }
    }
}

