/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.queue;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.commands.ISubCommand;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class QueueCommand
extends BaseCommand {
    public static Map<AdaptedPlayer, Long> cooldowns = new ConcurrentHashMap<AdaptedPlayer, Long>();
    private final QueueMain main;

    public QueueCommand(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "queue";
    }

    @Override
    public ImmutableList<String> getAliases() {
        ArrayList<String> aliases = new ArrayList<String>(Arrays.asList("move", "joinqueue", "joinq"));
        if (this.main.getConfig().getBoolean("enable-server-command")) {
            aliases.add("server");
        }
        return ImmutableList.copyOf(aliases);
    }

    @Override
    public ImmutableList<ISubCommand> getSubCommands() {
        return ImmutableList.builder().build();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return;
        }
        if (!sender.isPlayer()) {
            sender.sendMessage(this.getMessages().getComponent("errors.player-only", new String[0]));
            return;
        }
        AdaptedPlayer player = this.main.getPlatformMethods().senderToPlayer(sender);
        long lastUse = cooldowns.getOrDefault(player, 0L);
        if ((double)(System.currentTimeMillis() - lastUse) < this.main.getConfig().getDouble("queue-command-cooldown") * 1000.0) {
            sender.sendMessage(this.main.getMessages().getComponent("errors.too-fast-queue", new String[0]));
            return;
        }
        cooldowns.put(player, System.currentTimeMillis());
        if (args.length > 0) {
            if (this.main.getConfig().getBoolean("require-permission") && !player.hasPermission("ajqueue.queue." + args[0])) {
                sender.sendMessage(this.getMessages().getComponent("noperm", new String[0]));
                return;
            }
            if (this.main.getConfig().getBoolean("joinfrom-server-permission") && !player.hasPermission("ajqueue.joinfrom." + player.getServerName())) {
                player.sendMessage(this.getMessages().getComponent("errors.deny-joining-from-server", new String[0]));
                return;
            }
            this.main.getQueueManager().addToQueue(player, args[0]);
        } else {
            sender.sendMessage(this.getMessages().getComponent("commands.joinqueue.usage", new String[0]));
        }
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (!this.main.getConfig().getBoolean("tab-complete-queues")) {
            return new ArrayList<String>();
        }
        if (args.length == 1) {
            List<String> servers = this.filterCompletion((List<String>)this.main.getQueueManager().getServerNames(), args[0]);
            if (this.main.getConfig().getBoolean("require-permission")) {
                servers.removeIf(s -> !sender.hasPermission("ajqueue.queue." + s));
            }
            return servers;
        }
        return new ArrayList<String>();
    }
}

