/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.AdaptedPlayer;
import us.ajg0702.queue.api.server.AdaptedServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class Send
extends SubCommand {
    final QueueMain main;

    public Send(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "send";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.send";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(this.getMessages().getComponent("commands.send.usage", new String[0]));
            return;
        }
        if (this.main.getQueueManager().findServer(args[1]) == null) {
            sender.sendMessage(this.getMessages().getComponent("errors.server-not-exist", "SERVER:" + args[1]));
            return;
        }
        List<String> playerNames = this.main.getPlatformMethods().getPlayerNames(true);
        if (playerNames.contains(args[0].toLowerCase())) {
            AdaptedPlayer ply = this.main.getPlatformMethods().getPlayer(args[0]);
            if (ply == null) {
                sender.sendMessage(Component.text("player not found (even though it was in playerNames)"));
                return;
            }
            if (ply.getName() == null) {
                sender.sendMessage(Component.text("name null"));
            }
            this.main.getQueueManager().addToQueue(ply, args[1]);
            sender.sendMessage(this.getMessages().getComponent("send", "PLAYER:" + ply.getName(), "SERVER:" + args[1]));
        } else if (this.main.getQueueManager().getServerNames().contains((Object)args[0])) {
            AdaptedServer from = this.main.getPlatformMethods().getServer(args[0]);
            if (from == null) {
                sender.sendMessage(this.getMessages().getComponent("errors.server-not-exist", "SERVER:" + args[0]));
                return;
            }
            ArrayList<AdaptedPlayer> players = new ArrayList<AdaptedPlayer>(from.getPlayers());
            for (AdaptedPlayer ply : players) {
                this.main.getQueueManager().addToQueue(ply, args[1]);
            }
            sender.sendMessage(this.getMessages().getComponent("send", "PLAYER:" + args[0], "SERVER:" + args[1]));
        } else {
            sender.sendMessage(this.getMessages().getComponent("commands.send.player-not-found", new String[0]));
        }
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>(this.main.getPlatformMethods().getServerNames());
            options.addAll(this.main.getPlatformMethods().getPlayerNames(false));
            return options;
        }
        if (args.length == 2) {
            return this.main.getQueueManager().getServerNames();
        }
        return new ArrayList<String>();
    }
}

