/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.manage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.api.players.QueuePlayer;
import us.ajg0702.queue.api.queues.QueueServer;
import us.ajg0702.queue.commands.SubCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class Kick
extends SubCommand {
    final QueueMain main;

    public Kick(QueueMain main) {
        this.main = main;
    }

    @Override
    public String getName() {
        return "kick";
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return "ajqueue.manage.kick";
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        Object kickPlayers;
        if (!this.checkPermission(sender)) {
            return;
        }
        if (args.length < 1) {
            sender.sendMessage(this.getMessages().getComponent("commands.kick.usage", new String[0]));
            return;
        }
        if (args.length == 1) {
            kickPlayers = this.main.getQueueManager().findPlayerInQueuesByName(args[0]);
        } else {
            QueueServer queue = this.main.getQueueManager().findServer(args[1]);
            if (queue == null) {
                sender.sendMessage(this.getMessages().getComponent("commands.kick.unknown-server", "QUEUE:" + args[1]));
                return;
            }
            kickPlayers = Collections.singletonList(queue.findPlayer(args[0]));
        }
        if (kickPlayers.size() == 0) {
            sender.sendMessage(this.getMessages().getComponent("commands.kick.no-player", "PLAYER:" + args[0]));
            return;
        }
        Iterator iterator = kickPlayers.iterator();
        while (iterator.hasNext()) {
            QueuePlayer player = (QueuePlayer)iterator.next();
            player.getQueueServer().removePlayer(player);
        }
        sender.sendMessage(this.getMessages().getComponent("commands.kick.success", "PLAYER:" + args[0], "NUM:" + kickPlayers.size(), "s:" + (kickPlayers.size() == 1 ? "" : "s")));
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return this.main.getPlatformMethods().getPlayerNames(false);
        }
        if (args.length == 2) {
            return this.main.getQueueManager().getServerNames();
        }
        return new ArrayList<String>();
    }
}

