/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.queue.commands.commands.SlashServer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import us.ajg0702.queue.api.commands.ICommandSender;
import us.ajg0702.queue.commands.BaseCommand;
import us.ajg0702.queue.common.QueueMain;
import us.ajg0702.queue.libs.utils.common.Messages;

public class SlashServerCommand
extends BaseCommand {
    final QueueMain main;
    final String server;
    final String command;

    public SlashServerCommand(QueueMain main, String server) {
        this.main = main;
        this.server = server;
        this.command = server;
    }

    public SlashServerCommand(QueueMain main, String command, String server) {
        this.main = main;
        this.server = server;
        this.command = command;
    }

    @Override
    public String getName() {
        return this.command;
    }

    @Override
    public ImmutableList<String> getAliases() {
        return ImmutableList.of();
    }

    @Override
    public String getPermission() {
        return null;
    }

    @Override
    public Messages getMessages() {
        return this.main.getMessages();
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (!sender.isPlayer()) {
            sender.sendMessage(this.getMessages().getComponent("errors.player-only", new String[0]));
            return;
        }
        if (this.main.getConfig().getBoolean("require-permission") && !sender.hasPermission("ajqueue.queue." + this.server)) {
            sender.sendMessage(this.getMessages().getComponent("noperm", new String[0]));
            return;
        }
        this.main.getQueueManager().addToQueue(this.main.getPlatformMethods().senderToPlayer(sender), this.server);
    }

    @Override
    public List<String> autoComplete(ICommandSender sender, String[] args) {
        return new ArrayList<String>();
    }
}

